/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.integrity.batch;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.IdRef;
import org.nuxeo.ecm.automation.client.model.OperationInput;

public class DeleteProfileDocumentCommand
implements INuxeoCommand {
    private Log log = LogFactory.getLog((String)"batch");
    private final String uid;

    public DeleteProfileDocumentCommand(String uid) {
        this.uid = uid;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        OperationRequest request = nuxeoSession.newRequest("Document.QueryES");
        request.set("X-NXDocumentProperties", (Object)"*");
        request.set("query", (Object)("SELECT * FROM UserProfile WHERE ttc_userprofile:login = '" + this.uid + "'"));
        Documents userprofiles = (Documents)request.execute();
        this.log.info((Object)(userprofiles.size() + " profil(s) trouv\u00e9(s) dans nuxeo pour " + this.uid));
        for (Document userprofile : userprofiles) {
            String parentpath = StringUtils.substringBeforeLast((String)userprofile.getPath(), (String)"/");
            if (!StringUtils.isNotBlank((String)parentpath)) continue;
            request.set("query", (Object)("SELECT * FROM Workspace WHERE ecm:path STARTSWITH '" + parentpath + "'"));
            Documents userworkspaces = (Documents)request.execute();
            for (Document userworkspace : userworkspaces) {
                OperationRequest deleteCmd = nuxeoSession.newRequest("Services.PurgeDocuments");
                IdRef input = new IdRef(userworkspace.getId());
                deleteCmd.setInput((OperationInput)input);
                deleteCmd.execute();
                this.log.info((Object)("Suppression espace " + userworkspace.getId() + " pour " + this.uid));
            }
        }
        return userprofiles.size();
    }

    public String getId() {
        return null;
    }
}

