/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.integrity.batch;

import fr.gouv.education.foad.directory.model.TribuPerson;
import fr.gouv.education.foad.integrity.controller.SupprNumenForm;
import fr.toutatice.portail.cms.nuxeo.api.batch.NuxeoBatch;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletContext;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.directory.v2.service.PersonUpdateService;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Person;

public class SupprNumenBatch
extends NuxeoBatch {
    private static PortletContext portletContext;
    private Log log = LogFactory.getLog((String)"batch");
    private SupprNumenForm form;
    private PersonUpdateService personService = (PersonUpdateService)DirServiceFactory.getService(PersonUpdateService.class);

    public SupprNumenBatch(SupprNumenForm form) {
        super(form.getTemporaryFile().getName());
        this.form = form;
    }

    public String getJobScheduling() {
        return null;
    }

    public void execute(Map<String, Object> parameters) throws PortalException {
        try {
            CSVParser parser = CSVParser.parse((File)this.form.getTemporaryFile(), (Charset)StandardCharsets.UTF_8, (CSVFormat)CSVFormat.EXCEL);
            for (CSVRecord record : parser) {
                String numen = record.get(0).trim();
                if (!StringUtils.isNotBlank((String)numen)) continue;
                TribuPerson search = (TribuPerson)this.personService.getEmptyPerson();
                search.setHashNumen(numen);
                List findByCriteria = this.personService.findByCriteria((Person)search);
                if (findByCriteria.size() == 0) {
                    this.log.warn((Object)("Aucune personne trouv\u00e9e pour le NUMEN " + numen));
                }
                if (findByCriteria.size() > 1) {
                    this.log.warn((Object)("Plusieurs comptes trouv\u00e9s avec le NUMEN " + numen));
                }
                for (Person p : findByCriteria) {
                    TribuPerson person = (TribuPerson)p;
                    person.setHashNumen(null);
                    this.personService.update((Person)person);
                    this.log.info((Object)("Suppresion du NUMEN " + numen + " pour " + person.getUid()));
                }
            }
        }
        catch (IOException e) {
            throw new PortalException((Exception)e);
        }
    }

    public PortletContext getPortletContext() {
        return portletContext;
    }

    public static void setPortletContext(PortletContext portletContext) {
        SupprNumenBatch.portletContext = portletContext;
    }
}

