/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.integrity.batch;

import fr.gouv.education.foad.integrity.batch.DeleteProfileDocumentCommand;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.batch.NuxeoBatch;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.directory.v2.service.PersonUpdateService;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Person;

public class SupprUtilisateursNonCoBatch
extends NuxeoBatch {
    private static PortletContext portletContext;
    private Log log = LogFactory.getLog((String)"batch");
    private PersonUpdateService personService = (PersonUpdateService)DirServiceFactory.getService(PersonUpdateService.class);

    public PortletContext getPortletContext() {
        return portletContext;
    }

    public static void setPortletContext(PortletContext portletContext) {
        SupprUtilisateursNonCoBatch.portletContext = portletContext;
    }

    public String getJobScheduling() {
        String cron = System.getProperty("foad.purgeusers.cron");
        if (StringUtils.isNotBlank((String)cron)) {
            return cron;
        }
        return "0 0/15 * * * ?";
    }

    public void execute(Map<String, Object> parameters) throws PortalException {
        Person p = this.personService.getEmptyPerson();
        List persons = this.personService.findByNoConnectionDate(p);
        int supprLdap = 0;
        int supprNx = 0;
        if (persons != null) {
            for (Person person : persons) {
                this.log.info((Object)("Suppression de " + person.getUid()));
                DeleteProfileDocumentCommand command = new DeleteProfileDocumentCommand(person.getUid());
                Integer ret = (Integer)this.getNuxeoController().executeNuxeoCommand((INuxeoCommand)command);
                supprNx += ret.intValue();
                this.personService.delete(person);
                ++supprLdap;
            }
        }
        this.log.info((Object)("Total suppression ldap " + supprLdap + " et nuxeo " + supprNx));
    }
}

