/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.room.plugin;

import java.util.HashMap;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.BooleanUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.EcmDocument;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.IMenubarService;
import org.osivia.portal.api.menubar.MenubarContainer;
import org.osivia.portal.api.menubar.MenubarDropdown;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.portal.api.urls.IPortalUrlFactory;

public class RoomMenubarModule
implements MenubarModule {
    private final IMenubarService menubarService = (IMenubarService)Locator.findMBean(IMenubarService.class, (String)"osivia:service=MenubarService");
    private final IPortalUrlFactory portalUrlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
    private final IBundleFactory bundleFactory;

    public RoomMenubarModule() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public void customizeSpace(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext<? extends EcmDocument> spaceDocumentContext) throws PortalException {
        Document space;
        if (spaceDocumentContext != null && (space = (Document)spaceDocumentContext.getDoc()) != null) {
            boolean isGlobalAdministrator;
            String type = space.getType();
            PortletRequest request = portalControllerContext.getRequest();
            if ("Workspace".equals(type) && request != null && (isGlobalAdministrator = BooleanUtils.isTrue((Boolean)((Boolean)request.getAttribute("osivia.isAdministrator"))))) {
                HttpServletRequest servletRequest = portalControllerContext.getHttpServletRequest();
                Bundle bundle = this.bundleFactory.getBundle(servletRequest.getLocale());
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("osivia.title", bundle.getString("ROOM_MIG_TITLE"));
                properties.put("theme.dyna.partial_refresh_enabled", String.valueOf(true));
                properties.put("osivia.ajaxLink", "1");
                properties.put("osivia.back.reset", String.valueOf(true));
                properties.put("osivia.navigation.reset", String.valueOf(true));
                properties.put("osivia.cms.uri", space.getPath());
                String id = "ROOM_MIG";
                String title = bundle.getString("ROOM_MIG_TITLE");
                String icon = "halflings halflings-wrench";
                MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "CONFIGURATION");
                int order = 4;
                String url = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, "foad-room-instance", properties);
                String target = null;
                String onclick = null;
                String htmlClasses = null;
                MenubarItem menubarItem = new MenubarItem(id, title, icon, (MenubarContainer)parent, order, url, target, onclick, htmlClasses);
                menubar.add(menubarItem);
            }
        }
    }

    public void customizeDocument(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext<? extends EcmDocument> documentContext) throws PortalException {
    }
}

