/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.portlet.controller;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.services.workspace.portlet.model.Member;
import org.osivia.services.workspace.portlet.model.MemberManagementOptions;
import org.osivia.services.workspace.portlet.model.MembersForm;
import org.osivia.services.workspace.portlet.service.MemberManagementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class MemberManagementController {
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private MemberManagementService service;
    @Autowired
    protected IBundleFactory bundleFactory;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response, @ModelAttribute(value="members") MembersForm form, @ModelAttribute(value="options") MemberManagementOptions options, @RequestParam(value="sort", defaultValue="date") String sort, @RequestParam(value="alt", defaultValue="true") String alt) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        request.setAttribute("tab", (Object)"members");
        this.service.sortMembers(portalControllerContext, form, sort, BooleanUtils.toBoolean((String)alt));
        request.setAttribute("sort", (Object)sort);
        request.setAttribute("alt", (Object)alt);
        return "members/view";
    }

    @ExceptionHandler(value={PortletException.class})
    public String handlePortletException(PortletRequest request, PortletResponse response, PortletException exception) {
        request.setAttribute("exception", (Object)exception);
        return "error";
    }

    @ActionMapping(value="update")
    public void update(ActionRequest request, ActionResponse response, @ModelAttribute(value="options") MemberManagementOptions options, @ModelAttribute(value="members") MembersForm form) throws PortletException {
        String altParameter;
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.updateMembers(portalControllerContext, options, form);
        String sortParameter = request.getParameter("sort");
        if (StringUtils.isNotEmpty((String)sortParameter)) {
            response.setRenderParameter("sort", sortParameter);
        }
        if (StringUtils.isNotEmpty((String)(altParameter = request.getParameter("alt")))) {
            response.setRenderParameter("alt", altParameter);
        }
    }

    @ModelAttribute(value="options")
    public MemberManagementOptions getOptions(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getOptions(portalControllerContext);
    }

    @ModelAttribute(value="members")
    public MembersForm getMembersForm(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getMembersForm(portalControllerContext);
    }

    @ModelAttribute(value="help")
    public String getHelp(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getMembersHelp(portalControllerContext);
    }

    @ResourceMapping(value="exportCsv")
    public void exportCsv(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="members") MembersForm members, @ModelAttribute(value="options") MemberManagementOptions options) throws IOException {
        response.setContentType("text/csv");
        response.setProperty("Content-disposition", "attachment; filename=\"members_" + options.getWorkspaceId() + ".csv" + "\"");
        OutputStreamWriter writer = new OutputStreamWriter(response.getPortletOutputStream());
        ArrayList<String> headers = new ArrayList<String>();
        Bundle bundle = this.bundleFactory.getBundle(null);
        headers.add(bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_MEMBER"));
        headers.add(bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_MEMBER_EXTRA"));
        headers.add(bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_MEMBER_ACKNOWLEDGMENT_DATE"));
        headers.add(bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_ROLE"));
        headers.add(bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_ID"));
        CSVPrinter printer = CSVFormat.EXCEL.withHeader(headers.toArray(new String[headers.size()])).print((Appendable)writer);
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/YYYY");
        for (Member m : members.getMembers()) {
            String date = "";
            if (m.getDate() != null) {
                date = sdf.format(m.getDate());
            }
            String role = "";
            if (m.getRole() != null) {
                role = bundle.getString(m.getRole().getKey(), m.getRole().getClassLoader(), new Object[0]);
            }
            printer.printRecord(new Object[]{m.getDisplayName(), m.getExtra(), date, role, m.getId()});
        }
        printer.close();
        writer.close();
    }
}

