/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.portlet.controller;

import java.beans.PropertyEditor;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osivia.directory.v2.model.CollabProfile;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.workspace.portlet.model.InvitationEditionForm;
import org.osivia.services.workspace.portlet.model.MemberManagementOptions;
import org.osivia.services.workspace.portlet.model.converter.LocalGroupPropertyEditor;
import org.osivia.services.workspace.portlet.service.MemberManagementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.portlet.bind.PortletRequestDataBinder;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(path={"VIEW"}, params={"view=invitation-edition"})
@SessionAttributes(value={"invitationEditionForm"})
public class MemberManagementInvitationEditionController {
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private MemberManagementService service;
    @Autowired
    private LocalGroupPropertyEditor localGroupPropertyEditor;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) throws PortletException {
        request.setAttribute("tab", (Object)"invitations");
        request.setAttribute("view", (Object)"invitation-edition");
        return "invitation-edition/view";
    }

    @ActionMapping(value="redirectTab")
    public void redirectTab(ActionRequest request, ActionResponse response, @RequestParam(value="redirection") String redirection, SessionStatus sessionStatus) throws PortletException {
        sessionStatus.setComplete();
        response.setRenderParameter("tab", redirection);
    }

    @ActionMapping(name="submit", params={"resend"})
    public void resend(ActionRequest request, ActionResponse response, @ModelAttribute(value="invitationEditionForm") InvitationEditionForm form) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.resendInvitation(portalControllerContext, form);
        response.setRenderParameter("view", "invitation-edition");
        response.setRenderParameter("invitationPath", form.getPath());
    }

    @ActionMapping(name="submit", params={"save"})
    public void save(ActionRequest request, ActionResponse response, @ModelAttribute(value="invitationEditionForm") InvitationEditionForm form, SessionStatus sessionStatus) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.updateInvitation(portalControllerContext, form);
        sessionStatus.setComplete();
        response.setRenderParameter("tab", "invitations");
    }

    @ActionMapping(name="submit", params={"cancel"})
    public void cancel(ActionRequest request, ActionResponse response, @ModelAttribute(value="invitationEditionForm") InvitationEditionForm form, SessionStatus sessionStatus) throws PortletException {
        sessionStatus.setComplete();
        response.setRenderParameter("tab", "invitations");
    }

    @ActionMapping(value="delete")
    public void delete(ActionRequest request, ActionResponse response, @ModelAttribute(value="invitationEditionForm") InvitationEditionForm form, SessionStatus sessionStatus) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.deleteInvitation(portalControllerContext, form);
        sessionStatus.setComplete();
        response.setRenderParameter("tab", "invitations");
    }

    @ModelAttribute(value="invitationEditionForm")
    public InvitationEditionForm getInvitationEditionForm(PortletRequest request, PortletResponse response, @RequestParam(value="invitationPath") String path) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getInvitationEditionForm(portalControllerContext, path);
    }

    @InitBinder(value={"invitationEditionForm"})
    public void invitationEditionFormInitBinder(PortletRequestDataBinder binder) {
        binder.registerCustomEditor(CollabProfile.class, (PropertyEditor)this.localGroupPropertyEditor);
    }

    @ModelAttribute(value="options")
    public MemberManagementOptions getOptions(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getOptions(portalControllerContext);
    }
}

