/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.portlet.controller;

import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import net.sf.json.JSONObject;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.osivia.directory.v2.model.CollabProfile;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.services.workspace.portlet.model.Invitation;
import org.osivia.services.workspace.portlet.model.InvitationsCreationForm;
import org.osivia.services.workspace.portlet.model.InvitationsForm;
import org.osivia.services.workspace.portlet.model.MemberManagementOptions;
import org.osivia.services.workspace.portlet.model.converter.InvitationPropertyEditor;
import org.osivia.services.workspace.portlet.model.converter.LocalGroupPropertyEditor;
import org.osivia.services.workspace.portlet.model.validator.InvitationsCreationFormValidator;
import org.osivia.services.workspace.portlet.service.MemberManagementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.portlet.bind.PortletRequestDataBinder;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(path={"VIEW"}, params={"tab=invitations"})
@SessionAttributes(value={"creation"})
public class MemberManagementInvitationsController {
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private MemberManagementService service;
    @Autowired
    private InvitationsCreationFormValidator creationFormValidator;
    @Autowired
    private InvitationPropertyEditor invitationPropertyEditor;
    @Autowired
    private LocalGroupPropertyEditor localGroupPropertyEditor;
    @Autowired
    protected IBundleFactory bundleFactory;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response, @ModelAttribute(value="invitations") InvitationsForm form, @RequestParam(value="sort", defaultValue="date") String sort, @RequestParam(value="alt", defaultValue="true") String alt) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        request.setAttribute("tab", (Object)"invitations");
        this.service.sortInvitations(portalControllerContext, form, sort, BooleanUtils.toBoolean((String)alt));
        request.setAttribute("sort", (Object)sort);
        request.setAttribute("alt", (Object)alt);
        return "invitations/view";
    }

    @ActionMapping(value="update")
    public void update(ActionRequest request, ActionResponse response, @ModelAttribute(value="options") MemberManagementOptions options, @ModelAttribute(value="invitations") InvitationsForm form) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.updateInvitations(portalControllerContext, options, form);
        this.copyRenderParameters(request, response);
    }

    @ActionMapping(value="create")
    public void create(ActionRequest request, ActionResponse response, @ModelAttribute(value="options") MemberManagementOptions options, @ModelAttribute(value="invitations") InvitationsForm invitationsForm, @ModelAttribute(value="creation") @Validated InvitationsCreationForm creationForm, BindingResult result) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        if (result.hasErrors()) {
            creationForm.setWarning(false);
        } else {
            this.service.createInvitations(portalControllerContext, options, invitationsForm, creationForm);
        }
        this.copyRenderParameters(request, response);
    }

    @ActionMapping(value="purge")
    public void purge(ActionRequest request, ActionResponse response, @ModelAttribute(value="options") MemberManagementOptions options, @ModelAttribute(value="invitations") InvitationsForm form) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.purgeInvitationsHistory(portalControllerContext, options, form);
        this.copyRenderParameters(request, response);
    }

    private void copyRenderParameters(ActionRequest request, ActionResponse response) {
        String altParameter;
        response.setRenderParameter("tab", "invitations");
        String sortParameter = request.getParameter("sort");
        if (StringUtils.isNotEmpty((String)sortParameter)) {
            response.setRenderParameter("sort", sortParameter);
        }
        if (StringUtils.isNotEmpty((String)(altParameter = request.getParameter("alt")))) {
            response.setRenderParameter("alt", altParameter);
        }
    }

    @ResourceMapping(value="search")
    public void search(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="options") MemberManagementOptions options, @RequestParam(value="filter", required=false) String filter, @RequestParam(value="page", required=false) String page, @RequestParam(value="tokenizer", required=false) String tokenizer) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        JSONObject results = this.service.searchPersons(portalControllerContext, options, filter, NumberUtils.toInt((String)page, (int)1), BooleanUtils.toBoolean((String)tokenizer));
        response.setContentType("application/json");
        PrintWriter printWriter = new PrintWriter(response.getPortletOutputStream());
        printWriter.write(results.toString());
        printWriter.close();
    }

    @ModelAttribute(value="options")
    public MemberManagementOptions getOptions(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getOptions(portalControllerContext);
    }

    @ModelAttribute(value="invitations")
    public InvitationsForm getInvitationsForm(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getInvitationsForm(portalControllerContext);
    }

    @ModelAttribute(value="creation")
    public InvitationsCreationForm getInvitationsCreationForm(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getInvitationsCreationForm(portalControllerContext);
    }

    @InitBinder(value={"creation"})
    public void invitationsCreationFormInitBinder(PortletRequestDataBinder binder) {
        binder.addValidators(new Validator[]{this.creationFormValidator});
        binder.registerCustomEditor(Invitation.class, (PropertyEditor)this.invitationPropertyEditor);
        binder.registerCustomEditor(CollabProfile.class, (PropertyEditor)this.localGroupPropertyEditor);
    }

    @ModelAttribute(value="help")
    public String getHelp(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getInvitationsHelp(portalControllerContext);
    }

    @ResourceMapping(value="exportCsv")
    public void exportCsv(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="invitations") InvitationsForm invitations, @ModelAttribute(value="options") MemberManagementOptions options) throws IOException {
        response.setContentType("text/csv");
        response.setProperty("Content-disposition", "attachment; filename=\"invitations_" + options.getWorkspaceId() + ".csv" + "\"");
        OutputStreamWriter writer = new OutputStreamWriter(response.getPortletOutputStream());
        ArrayList<String> headers = new ArrayList<String>();
        Bundle bundle = this.bundleFactory.getBundle(null);
        headers.add(bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_INVITATION"));
        headers.add(bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_MEMBER_EXTRA"));
        headers.add(bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_INVITATION_DATE"));
        headers.add(bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_INVITATION_RESENDING_DATE_EXP"));
        headers.add(bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_ROLE"));
        headers.add(bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_INVITATION_STATE"));
        headers.add(bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_ID"));
        CSVPrinter printer = CSVFormat.EXCEL.withHeader(headers.toArray(new String[headers.size()])).print((Appendable)writer);
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/YYYY");
        for (Invitation m : invitations.getInvitations()) {
            String date = "";
            if (m.getDate() != null) {
                date = sdf.format(m.getDate());
            }
            String resendingDate = "";
            if (m.getResendingDate() != null) {
                resendingDate = sdf.format(m.getResendingDate());
            }
            String role = "";
            if (m.getRole() != null) {
                role = bundle.getString(m.getRole().getKey(), m.getRole().getClassLoader(), new Object[0]);
            }
            String state = "";
            if (m.getState() != null) {
                state = bundle.getString(m.getState().getKey());
            }
            printer.printRecord(new Object[]{m.getDisplayName(), m.getExtra(), date, resendingDate, role, state, m.getId()});
        }
        printer.close();
        writer.close();
    }
}

