/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.portlet.controller;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.workspace.portlet.model.InvitationRequestsForm;
import org.osivia.services.workspace.portlet.model.MemberManagementOptions;
import org.osivia.services.workspace.portlet.service.MemberManagementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(path={"VIEW"}, params={"tab=requests"})
public class MemberManagementRequestsController {
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private MemberManagementService service;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response, @ModelAttribute(value="invitationRequests") InvitationRequestsForm form, @RequestParam(value="sort", defaultValue="date") String sort, @RequestParam(value="alt", defaultValue="true") String alt) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        request.setAttribute("tab", (Object)"requests");
        this.service.sortInvitationRequests(portalControllerContext, form, sort, BooleanUtils.toBoolean((String)alt));
        request.setAttribute("sort", (Object)sort);
        request.setAttribute("alt", (Object)alt);
        return "requests/view";
    }

    @ActionMapping(value="update")
    public void update(ActionRequest request, ActionResponse response, @ModelAttribute(value="options") MemberManagementOptions options, @ModelAttribute(value="invitationRequests") InvitationRequestsForm form) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.updateInvitationRequests(portalControllerContext, options, form);
        this.copyRenderParameters(request, response);
    }

    private void copyRenderParameters(ActionRequest request, ActionResponse response) {
        String altParameter;
        response.setRenderParameter("tab", "requests");
        String sortParameter = request.getParameter("sort");
        if (StringUtils.isNotEmpty((String)sortParameter)) {
            response.setRenderParameter("sort", sortParameter);
        }
        if (StringUtils.isNotEmpty((String)(altParameter = request.getParameter("alt")))) {
            response.setRenderParameter("alt", altParameter);
        }
    }

    @ModelAttribute(value="options")
    public MemberManagementOptions getOptions(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getOptions(portalControllerContext);
    }

    @ModelAttribute(value="invitationRequests")
    public InvitationRequestsForm getInvitationRequestsForm(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getInvitationRequestsForm(portalControllerContext);
    }

    @ModelAttribute(value="help")
    public String getHelp(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getInvitationRequestsHelp(portalControllerContext);
    }
}

