/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.portlet.model.comparator;

import java.util.Comparator;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.osivia.services.workspace.portlet.model.Invitation;
import org.osivia.services.workspace.portlet.model.InvitationState;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class InvitationComparator
implements Comparator<Invitation> {
    private final String sort;
    private final boolean alt;

    public InvitationComparator(String sort, boolean alt) {
        this.sort = sort;
        this.alt = alt;
    }

    @Override
    public int compare(Invitation invitation1, Invitation invitation2) {
        Date date2;
        Date date1;
        int result;
        if (invitation1 == null) {
            result = -1;
        } else if (invitation2 == null) {
            result = 1;
        } else if ("date".equals(this.sort)) {
            date1 = invitation1.getDate();
            date2 = invitation2.getDate();
            result = date1.compareTo(date2);
        } else if ("role".equals(this.sort)) {
            Integer role1 = invitation1.getRole().getWeight();
            Integer role2 = invitation2.getRole().getWeight();
            result = role1.compareTo(role2);
        } else if ("state".equals(this.sort)) {
            InvitationState state1 = invitation1.getState();
            InvitationState state2 = invitation2.getState();
            result = state1 == null ? -1 : (state2 == null ? 1 : state1.name().compareTo(state2.name()));
        } else {
            String name1 = StringUtils.defaultIfBlank((String)invitation1.getDisplayName(), (String)invitation1.getId());
            String name2 = StringUtils.defaultIfBlank((String)invitation2.getDisplayName(), (String)invitation2.getId());
            result = name1.compareToIgnoreCase(name2);
        }
        if (this.alt) {
            result = -result;
        }
        if (result == 0 && !"date".equals(this.sort)) {
            date1 = invitation1.getDate();
            date2 = invitation2.getDate();
            result = date2.compareTo(date1);
        }
        return result;
    }
}

