/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.portlet.model.comparator;

import java.util.Comparator;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.services.workspace.portlet.model.MemberObject;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class MemberObjectComparator
implements Comparator<MemberObject> {
    private final String sort;
    private final boolean alt;
    private final Log log;

    public MemberObjectComparator(String sort, boolean alt) {
        this.sort = sort;
        this.alt = alt;
        this.log = LogFactory.getLog(this.getClass());
    }

    @Override
    public int compare(MemberObject memberObject1, MemberObject memberObject2) {
        int result;
        if (memberObject1 == null) {
            result = -1;
        } else if (memberObject2 == null) {
            result = 1;
        } else if ("date".equals(this.sort)) {
            result = this.compareDates(memberObject1, memberObject2);
        } else if ("role".equals(this.sort)) {
            Integer role1 = 0;
            if (memberObject1.getRole() != null) {
                role1 = memberObject1.getRole().getWeight();
            } else {
                this.log.error((Object)(memberObject1.getId() + " has no role !"));
            }
            Integer role2 = 0;
            if (memberObject2.getRole() != null) {
                role2 = memberObject2.getRole().getWeight();
            } else {
                this.log.error((Object)(memberObject2.getId() + " has no role !"));
            }
            result = role1.compareTo(role2);
        } else {
            String name1 = StringUtils.defaultIfBlank((String)memberObject1.getDisplayName(), (String)memberObject1.getId());
            String name2 = StringUtils.defaultIfBlank((String)memberObject2.getDisplayName(), (String)memberObject2.getId());
            result = name1.compareToIgnoreCase(name2);
        }
        if (this.alt) {
            result = -result;
        }
        if (result == 0 && !"date".equals(this.sort)) {
            result = this.compareDates(memberObject1, memberObject2);
        }
        return result;
    }

    private int compareDates(MemberObject memberObject1, MemberObject memberObject2) {
        Date date1 = memberObject1.getDate();
        Date date2 = memberObject2.getDate();
        int result = date1 == null ? -1 : (date2 == null ? 1 : date1.compareTo(date2));
        return result;
    }
}

