/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.portlet.service;

import fr.toutatice.portail.cms.nuxeo.api.workspace.WorkspaceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.directory.v2.model.ext.WorkspaceRole;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.services.workspace.portlet.model.Invitation;
import org.osivia.services.workspace.portlet.model.InvitationEditionForm;
import org.osivia.services.workspace.portlet.model.InvitationRequest;
import org.osivia.services.workspace.portlet.model.InvitationRequestsForm;
import org.osivia.services.workspace.portlet.model.InvitationState;
import org.osivia.services.workspace.portlet.model.InvitationsCreationForm;
import org.osivia.services.workspace.portlet.model.InvitationsForm;
import org.osivia.services.workspace.portlet.model.Member;
import org.osivia.services.workspace.portlet.model.MemberManagementOptions;
import org.osivia.services.workspace.portlet.model.MembersForm;
import org.osivia.services.workspace.portlet.model.comparator.InvitationComparator;
import org.osivia.services.workspace.portlet.model.comparator.LocalGroupComparator;
import org.osivia.services.workspace.portlet.model.comparator.MemberObjectComparator;
import org.osivia.services.workspace.portlet.repository.MemberManagementRepository;
import org.osivia.services.workspace.portlet.service.MemberManagementService;
import org.osivia.services.workspace.util.ApplicationContextProvider;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.validation.Errors;

@Service
public class MemberManagementServiceImpl
implements MemberManagementService,
ApplicationContextAware {
    private static final String MAIL_REGEX = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private ApplicationContext applicationContext;
    @Autowired
    private MemberManagementRepository repository;
    @Autowired
    protected IBundleFactory bundleFactory;
    @Autowired
    protected INotificationsService notificationsService;
    @Autowired
    private LocalGroupComparator localGroupComparator;
    private final Pattern mailPattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
    private final Log log = LogFactory.getLog(this.getClass());

    public MemberManagementOptions getOptions(PortalControllerContext portalControllerContext) throws PortletException {
        MemberManagementOptions options = (MemberManagementOptions)this.applicationContext.getBean(MemberManagementOptions.class);
        if (options.getWorkspaceId() == null) {
            String workspaceId = this.repository.getCurrentWorkspaceId(portalControllerContext);
            options.setWorkspaceId(workspaceId);
            WorkspaceType type = this.repository.getCurrentWorkspaceType(portalControllerContext);
            options.setWorkspaceType(type);
            int invitationsCount = this.repository.getInvitationsCount(portalControllerContext, workspaceId);
            options.setInvitationsCount(invitationsCount);
            if (!WorkspaceType.INVITATION.equals((Object)type)) {
                int requestsCount = this.repository.getRequestsCount(portalControllerContext, workspaceId);
                options.setRequestsCount(requestsCount);
            }
            List roles = this.repository.getRoles(portalControllerContext, workspaceId);
            options.setRoles(roles);
            List localGroups = this.repository.getLocalGroups(portalControllerContext, workspaceId);
            Collections.sort(localGroups, this.localGroupComparator);
            options.setWorkspaceLocalGroups(localGroups);
        }
        return options;
    }

    public MembersForm getMembersForm(PortalControllerContext portalControllerContext) throws PortletException {
        MembersForm form = (MembersForm)this.applicationContext.getBean(MembersForm.class);
        if (!form.isLoaded()) {
            String workspaceId = this.repository.getCurrentWorkspaceId(portalControllerContext);
            List members = this.repository.getMembers(portalControllerContext, workspaceId);
            form.setMembers(members);
            HashSet<String> identifiers = new HashSet<String>();
            for (Member member : members) {
                identifiers.add(member.getId());
            }
            form.setIdentifiers(identifiers);
            form.setLoaded(true);
        }
        return form;
    }

    public void sortMembers(PortalControllerContext portalControllerContext, MembersForm form, String sort, boolean alt) throws PortletException {
        MemberObjectComparator comparator = (MemberObjectComparator)this.applicationContext.getBean(MemberObjectComparator.class, new Object[]{sort, alt});
        try {
            Collections.sort(form.getMembers(), comparator);
        }
        catch (IllegalArgumentException e) {
            this.log.error((Object)"Impossible de trier les membres ", (Throwable)e);
        }
    }

    public void updateMembers(PortalControllerContext portalControllerContext, MemberManagementOptions options, MembersForm form) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        for (Member member : form.getMembers()) {
            this.repository.updateMember(portalControllerContext, options.getWorkspaceId(), member);
        }
        this.invalidateLoadedForms();
        this.getMembersForm(portalControllerContext);
        String message = bundle.getString("MESSAGE_WORKSPACE_MEMBERS_UPDATE_SUCCESS");
        this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
    }

    public String getMembersHelp(PortalControllerContext portalControllerContext) throws PortletException {
        return this.repository.getHelp(portalControllerContext, "workspace-member-management.members.help.location");
    }

    public InvitationsForm getInvitationsForm(PortalControllerContext portalControllerContext) throws PortletException {
        InvitationsForm form = (InvitationsForm)this.applicationContext.getBean(InvitationsForm.class);
        if (!form.isLoaded()) {
            String workspaceId = this.repository.getCurrentWorkspaceId(portalControllerContext);
            Set identifiers = this.getMembersForm(portalControllerContext).getIdentifiers();
            List invitations = this.repository.getInvitations(portalControllerContext, workspaceId, identifiers);
            form.setInvitations(invitations);
            HashSet<String> invitationIdentifiers = new HashSet<String>();
            boolean purgeAvailable = false;
            for (Invitation invitation : invitations) {
                if (InvitationState.SENT.equals((Object)invitation.getState())) {
                    invitationIdentifiers.add(invitation.getId());
                    continue;
                }
                purgeAvailable = true;
            }
            form.setIdentifiers(invitationIdentifiers);
            form.setPurgeAvailable(purgeAvailable);
            form.setLoaded(true);
        }
        return form;
    }

    public InvitationsCreationForm getInvitationsCreationForm(PortalControllerContext portalControllerContext) throws PortletException {
        InvitationsCreationForm form = (InvitationsCreationForm)this.applicationContext.getBean(InvitationsCreationForm.class);
        form.setRole(WorkspaceRole.READER);
        return form;
    }

    public JSONObject searchPersons(PortalControllerContext portalControllerContext, MemberManagementOptions options, String filter, int page, boolean tokenizer) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        boolean invitationOnly = WorkspaceType.INVITATION.equals((Object)options.getWorkspaceType());
        Set memberIdentifiers = this.getMembersForm(portalControllerContext).getIdentifiers();
        Set invitationIndentifiers = this.getInvitationsForm(portalControllerContext).getIdentifiers();
        Set requestIdentifiers = invitationOnly ? null : this.getInvitationRequestsForm(portalControllerContext).getIdentifiers();
        ArrayList<JSONObject> objects = new ArrayList<JSONObject>();
        int total = 0;
        String[] parts = StringUtils.isBlank((String)filter) ? new String[]{""} : StringUtils.split((String)filter, (String)",;");
        for (String part : parts) {
            List persons = this.repository.searchPersons(portalControllerContext, part, tokenizer);
            for (Person person : persons) {
                boolean alreadyMember = memberIdentifiers.contains(person.getUid());
                boolean alreadyInvited = invitationIndentifiers.contains(person.getUid());
                boolean existingRequest = !invitationOnly && requestIdentifiers.contains(person.getUid());
                JSONObject object = this.getSearchResult(person, alreadyMember, alreadyInvited, existingRequest, bundle);
                objects.add(object);
                ++total;
            }
            if (!this.enablePersonCreation() || tokenizer && !persons.isEmpty()) continue;
            this.addPersonCreationSearchResult(persons, objects, part, bundle);
        }
        JSONObject results = new JSONObject();
        JSONArray items = new JSONArray();
        if (tokenizer) {
            items.addAll(objects);
        } else {
            if (page == 1) {
                String message = this.getSearchResultsMessage(portalControllerContext, total, bundle);
                JSONObject object = new JSONObject();
                object.put((Object)"message", (Object)message);
                items.add((Object)object);
            }
            int begin = (page - 1) * 6;
            int end = Math.min(objects.size(), begin + 6);
            for (int i = begin; i < end; ++i) {
                JSONObject object = (JSONObject)objects.get(i);
                items.add((Object)object);
            }
            results.put((Object)"page", (Object)page);
            results.put((Object)"pageSize", (Object)6);
        }
        results.put((Object)"items", (Object)items);
        results.put((Object)"total", (Object)objects.size());
        return results;
    }

    protected JSONObject getSearchResult(Person person, boolean alreadyMember, boolean alreadyInvited, boolean existingRequest, Bundle bundle) {
        String extra;
        String displayName;
        JSONObject object = new JSONObject();
        object.put((Object)"id", (Object)person.getUid());
        if (StringUtils.isEmpty((String)person.getDisplayName())) {
            displayName = person.getUid();
            extra = null;
        } else {
            displayName = person.getDisplayName();
            extra = person.getUid();
            if (StringUtils.isNotBlank((String)person.getMail()) && !StringUtils.equals((String)person.getUid(), (String)person.getMail())) {
                extra = extra + " \u2013 " + person.getMail();
            }
        }
        if (alreadyMember) {
            displayName = displayName + " " + bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_ALREADY_MEMBER_INDICATOR");
            object.put((Object)"disabled", (Object)true);
        } else if (alreadyInvited) {
            displayName = displayName + " " + bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_ALREADY_INVITED");
            object.put((Object)"disabled", (Object)true);
        } else if (existingRequest) {
            displayName = displayName + " " + bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_EXISTING_INVITATION_REQUEST_INDICATOR");
            object.put((Object)"disabled", (Object)true);
        }
        object.put((Object)"displayName", (Object)displayName);
        object.put((Object)"extra", (Object)extra);
        object.put((Object)"avatar", (Object)person.getAvatar().getUrl());
        return object;
    }

    protected boolean enablePersonCreation() {
        return true;
    }

    protected void addPersonCreationSearchResult(List<Person> persons, List<JSONObject> objects, String filter, Bundle bundle) throws PortletException {
        Matcher matcher = this.mailPattern.matcher(filter);
        boolean exists = false;
        if (matcher.matches()) {
            for (Person person : persons) {
                if (!filter.equalsIgnoreCase(person.getMail())) continue;
                exists = true;
                break;
            }
        }
        if (!exists) {
            JSONObject object = new JSONObject();
            object.put((Object)"id", (Object)filter);
            object.put((Object)"create", (Object)true);
            if (matcher.matches()) {
                object.put((Object)"displayName", (Object)bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_INVITATIONS_CREATE_PERSON"));
                object.put((Object)"extra", (Object)bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_INVITATIONS_CREATE_PERSON_EXTRA", new Object[]{filter}));
            } else {
                object.put((Object)"displayName", (Object)bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_INVITATIONS_CREATE_PERSON_INVALID"));
                object.put((Object)"extra", (Object)bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_INVITATIONS_CREATE_PERSON_INVALID_EXTRA", new Object[]{filter}));
                object.put((Object)"disabled", (Object)true);
            }
            objects.add(object);
        }
    }

    protected String getSearchResultsMessage(PortalControllerContext portalControllerContext, int total, Bundle bundle) throws PortletException {
        String message = total == 0 ? bundle.getString("SELECT2_NO_RESULTS") : (total == 1 ? bundle.getString("SELECT2_ONE_RESULT") : (total > 100 ? bundle.getString("SELECT2_TOO_MANY_RESULTS", new Object[]{100}) : bundle.getString("SELECT2_MULTIPLE_RESULTS", new Object[]{total})));
        return message;
    }

    public void sortInvitations(PortalControllerContext portalControllerContext, InvitationsForm form, String sort, boolean alt) throws PortletException {
        InvitationComparator comparator = (InvitationComparator)this.applicationContext.getBean(InvitationComparator.class, new Object[]{sort, alt});
        Collections.sort(form.getInvitations(), comparator);
    }

    public void updateInvitations(PortalControllerContext portalControllerContext, MemberManagementOptions options, InvitationsForm form) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        String workspaceId = options.getWorkspaceId();
        this.repository.updateInvitations(portalControllerContext, form.getInvitations());
        int count = this.repository.getInvitationsCount(portalControllerContext, workspaceId);
        options.setInvitationsCount(count);
        this.invalidateLoadedForms();
        this.getInvitationsForm(portalControllerContext);
        String message = bundle.getString("MESSAGE_WORKSPACE_INVITATIONS_UPDATE_SUCCESS");
        this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
    }

    public void purgeInvitationsHistory(PortalControllerContext portalControllerContext, MemberManagementOptions options, InvitationsForm form) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        List invitations = form.getInvitations();
        if (CollectionUtils.isNotEmpty((Collection)invitations)) {
            for (Invitation invitation : invitations) {
                if (InvitationState.SENT.equals((Object)invitation.getState())) continue;
                invitation.setDeleted(true);
            }
            this.repository.updateInvitations(portalControllerContext, form.getInvitations());
            form.setLoaded(false);
            this.getInvitationsForm(portalControllerContext);
            String message = bundle.getString("MESSAGE_WORKSPACE_INVITATIONS_PURGE_SUCCESS");
            this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
        }
    }

    public void validateInvitationsCreationForm(Errors errors, InvitationsCreationForm form) {
        if (CollectionUtils.isNotEmpty((Collection)form.getPendingInvitations())) {
            for (Invitation invitation : form.getPendingInvitations()) {
                Matcher matcher;
                if (!invitation.isUnknownUser() || (matcher = this.mailPattern.matcher(StringUtils.trim((String)invitation.getId()))).matches()) continue;
                Object[] errorArgs = new Object[]{invitation.getId()};
                errors.rejectValue("pendingInvitations", "Invalid", errorArgs, null);
            }
        }
    }

    public void createInvitations(PortalControllerContext portalControllerContext, MemberManagementOptions options, InvitationsForm invitationsForm, InvitationsCreationForm creationForm) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        ArrayList<String> invitationIdentifiers = new ArrayList<String>(creationForm.getPendingInvitations().size());
        for (Invitation invitation : creationForm.getPendingInvitations()) {
            if (!invitation.isUnknownUser()) continue;
            invitationIdentifiers.add(invitation.getId());
        }
        if (invitationIdentifiers.isEmpty() || creationForm.isWarning()) {
            boolean created = this.repository.createInvitations(portalControllerContext, options.getWorkspaceId(), invitationsForm.getInvitations(), creationForm);
            if (created) {
                options.setInvitationsCount(this.repository.getInvitationsCount(portalControllerContext, options.getWorkspaceId()));
                invitationsForm.setLoaded(false);
                creationForm.setLocalGroups(null);
                creationForm.setMessage(null);
                this.getInvitationsForm(portalControllerContext);
                String message = bundle.getString("MESSAGE_WORKSPACE_INVITATIONS_CREATION_SUCCESS");
                this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
            }
            creationForm.getPendingInvitations().clear();
            creationForm.setWarning(false);
        } else {
            creationForm.setWarning(true);
        }
    }

    public String getInvitationsHelp(PortalControllerContext portalControllerContext) throws PortletException {
        return this.repository.getHelp(portalControllerContext, "workspace-member-management.invitations.help.location");
    }

    public InvitationRequestsForm getInvitationRequestsForm(PortalControllerContext portalControllerContext) throws PortletException {
        InvitationRequestsForm form = (InvitationRequestsForm)this.applicationContext.getBean(InvitationRequestsForm.class);
        if (!form.isLoaded()) {
            String workspaceId = this.repository.getCurrentWorkspaceId(portalControllerContext);
            Set memberIdentifiers = this.getMembersForm(portalControllerContext).getIdentifiers();
            List requests = this.repository.getInvitationRequests(portalControllerContext, workspaceId, memberIdentifiers);
            form.setRequests(requests);
            HashSet<String> requestIdentifiers = new HashSet<String>();
            for (InvitationRequest request : requests) {
                if (!InvitationState.SENT.equals((Object)request.getState())) continue;
                requestIdentifiers.add(request.getId());
            }
            form.setIdentifiers(requestIdentifiers);
            form.setLoaded(true);
        }
        return form;
    }

    public void sortInvitationRequests(PortalControllerContext portalControllerContext, InvitationRequestsForm form, String sort, boolean alt) throws PortletException {
        MemberObjectComparator comparator = (MemberObjectComparator)this.applicationContext.getBean(MemberObjectComparator.class, new Object[]{sort, alt});
        Collections.sort(form.getRequests(), comparator);
    }

    public void updateInvitationRequests(PortalControllerContext portalControllerContext, MemberManagementOptions options, InvitationRequestsForm form) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        String workspaceId = options.getWorkspaceId();
        this.repository.updateInvitationRequests(portalControllerContext, workspaceId, form.getRequests());
        int count = this.repository.getInvitationsCount(portalControllerContext, workspaceId);
        options.setRequestsCount(count);
        this.invalidateLoadedForms();
        this.getInvitationRequestsForm(portalControllerContext);
        String message = bundle.getString("MESSAGE_WORKSPACE_INVITATION_REQUESTS_UPDATE_SUCCESS");
        this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
    }

    public String getInvitationRequestsHelp(PortalControllerContext portalControllerContext) throws PortletException {
        return this.repository.getHelp(portalControllerContext, "workspace-member-management.requests.help.location");
    }

    public InvitationEditionForm getInvitationEditionForm(PortalControllerContext portalControllerContext, String path) throws PortletException {
        return this.repository.getInvitationEditionForm(portalControllerContext, path);
    }

    public void resendInvitation(PortalControllerContext portalControllerContext, InvitationEditionForm form) throws PortletException {
        Date resendingDate = new Date();
        this.repository.resendInvitation(portalControllerContext, form, resendingDate);
        String message = form.getMessage();
        form.setMessage(null);
        form.getInvitation().setMessage(message);
        form.getInvitation().setResendingDate(resendingDate);
        this.invalidateLoadedForms();
    }

    public void updateInvitation(PortalControllerContext portalControllerContext, InvitationEditionForm form) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        Invitation invitation = form.getInvitation();
        invitation.setEdited(true);
        ArrayList<Invitation> invitations = new ArrayList<Invitation>(1);
        invitations.add(invitation);
        this.repository.updateInvitations(portalControllerContext, invitations);
        this.invalidateLoadedForms();
        String message = bundle.getString("MESSAGE_WORKSPACE_INVITATION_UPDATE_SUCCESS");
        this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
    }

    public void deleteInvitation(PortalControllerContext portalControllerContext, InvitationEditionForm form) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        Invitation invitation = form.getInvitation();
        invitation.setDeleted(true);
        ArrayList<Invitation> invitations = new ArrayList<Invitation>(1);
        invitations.add(invitation);
        this.repository.updateInvitations(portalControllerContext, invitations);
        this.invalidateLoadedForms();
        String message = bundle.getString("MESSAGE_WORKSPACE_INVITATION_DELETE_SUCCESS");
        this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
    }

    protected void invalidateLoadedForms() {
        MembersForm membersForm = (MembersForm)this.applicationContext.getBean(MembersForm.class);
        membersForm.setLoaded(false);
        InvitationsForm invitationsForm = (InvitationsForm)this.applicationContext.getBean(InvitationsForm.class);
        invitationsForm.setLoaded(false);
        InvitationRequestsForm requestsForm = (InvitationRequestsForm)this.applicationContext.getBean(InvitationRequestsForm.class);
        requestsForm.setLoaded(false);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        ApplicationContextProvider.setApplicationContext((ApplicationContext)applicationContext);
    }
}

