/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.portlet.model.comparator;

import java.util.Comparator;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.osivia.services.workspace.portlet.model.Invitation;
import org.osivia.services.workspace.portlet.model.InvitationObject;
import org.osivia.services.workspace.portlet.model.InvitationState;
import org.osivia.services.workspace.portlet.model.MembersSort;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class InvitationObjectComparator
implements Comparator<InvitationObject> {
    private final MembersSort sort;
    private final boolean alt;

    public InvitationObjectComparator(MembersSort sort, boolean alt) {
        this.sort = sort;
        this.alt = alt;
    }

    @Override
    public int compare(InvitationObject invitation1, InvitationObject invitation2) {
        Date date2;
        Date date1;
        int result;
        if (invitation1 == null) {
            result = -1;
        } else if (invitation2 == null) {
            result = 1;
        } else if (MembersSort.DATE.equals((Object)this.sort)) {
            date1 = invitation1.getDate();
            date2 = invitation2.getDate();
            if (invitation1 instanceof Invitation && invitation2 instanceof Invitation) {
                Invitation i1 = (Invitation)invitation1;
                Invitation i2 = (Invitation)invitation2;
                if (i1.getResendingDate() != null) {
                    date1 = i1.getResendingDate();
                }
                if (i2.getResendingDate() != null) {
                    date2 = i2.getResendingDate();
                }
            }
            result = date1.compareTo(date2);
        } else if (MembersSort.ROLE.equals((Object)this.sort)) {
            Integer role1 = invitation1.getRole().getWeight();
            Integer role2 = invitation2.getRole().getWeight();
            result = role1.compareTo(role2);
        } else if (MembersSort.INVITATION_STATE.equals((Object)this.sort)) {
            InvitationState state1 = invitation1.getState();
            InvitationState state2 = invitation2.getState();
            result = state1 == null ? -1 : (state2 == null ? 1 : state1.name().compareTo(state2.name()));
        } else {
            String name1 = StringUtils.defaultIfBlank((String)invitation1.getDisplayName(), (String)invitation1.getId());
            String name2 = StringUtils.defaultIfBlank((String)invitation2.getDisplayName(), (String)invitation2.getId());
            result = name1.compareToIgnoreCase(name2);
        }
        if (this.alt) {
            result = -result;
        }
        if (result == 0 && !MembersSort.DATE.equals((Object)this.sort)) {
            date1 = invitation1.getDate();
            date2 = invitation2.getDate();
            result = date2.compareTo(date1);
        }
        return result;
    }
}

