/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.directory.v2.model.CollabProfile;
import org.osivia.services.workspace.portlet.model.InvitationState;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class SetProcedureInstanceAcl
implements INuxeoCommand {
    private final String workspaceId;
    private final String modelId;
    private final String uid;
    private final List<CollabProfile> groups;

    public SetProcedureInstanceAcl(String workspaceId, String uid, List<CollabProfile> groups) {
        this(workspaceId, false, uid, groups);
    }

    public SetProcedureInstanceAcl(String workspaceId, boolean request, String uid, List<CollabProfile> groups) {
        this.workspaceId = workspaceId;
        this.modelId = request ? "invitation-request" : "invitation";
        this.uid = uid;
        this.groups = groups;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        Document instance = this.getProcedureInstance(nuxeoSession);
        for (CollabProfile group : this.groups) {
            documentService.addPermission((DocRef)instance, group.getCn(), "Everything");
        }
        return null;
    }

    private Document getProcedureInstance(Session nuxeoSession) throws Exception {
        StringBuilder clause = new StringBuilder();
        clause.append("ecm:primaryType = 'ProcedureInstance' ");
        clause.append("AND pi:procedureModelWebId = '").append("procedure_").append(this.modelId).append("' ");
        clause.append("AND pi:globalVariablesValues.").append("workspaceId").append(" = '").append(this.workspaceId).append("' ");
        clause.append("AND pi:globalVariablesValues.").append("invitationState").append(" = '").append(InvitationState.SENT.toString()).append("' ");
        if (StringUtils.isNotEmpty((String)this.uid)) {
            clause.append("AND pi:globalVariablesValues.").append("uid").append(" = '").append(this.uid).append("' ");
        }
        String filteredClause = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)NuxeoQueryFilterContext.CONTEXT_LIVE, (String)clause.toString());
        OperationRequest request = nuxeoSession.newRequest("Document.QueryES");
        request.set("X-NXDocumentProperties", (Object)"dublincore");
        request.set("query", (Object)("SELECT * FROM Document WHERE " + filteredClause));
        Documents documents = (Documents)request.execute();
        if (documents.size() != 1) {
            throw new NuxeoException(NuxeoException.ERROR_NOTFOUND);
        }
        Document document = documents.get(0);
        return document;
    }

    public String getId() {
        return null;
    }
}

