/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.plugin.menubar;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.EcmDocument;
import org.osivia.portal.api.cms.impl.BasicPermissions;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.IMenubarService;
import org.osivia.portal.api.menubar.MenubarContainer;
import org.osivia.portal.api.menubar.MenubarDropdown;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.portal.api.urls.IPortalUrlFactory;

public class MemberManagementMenubarModule
implements MenubarModule {
    public static final String MENUBAR_ITEM_ID = "WORKSPACE_MEMBER_MANAGEMENT";
    private final IMenubarService menubarService = (IMenubarService)Locator.findMBean(IMenubarService.class, (String)"osivia:service=MenubarService");
    private final IPortalUrlFactory portalUrlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
    private final IBundleFactory bundleFactory;

    public MemberManagementMenubarModule() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public void customizeSpace(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext<? extends EcmDocument> spaceDocumentContext) throws PortalException {
        BasicPermissions permissions;
        String type;
        Document space;
        if (spaceDocumentContext != null && (space = (Document)spaceDocumentContext.getDoc()) != null && "Workspace".equals(type = space.getType()) && (permissions = (BasicPermissions)spaceDocumentContext.getPermissions(BasicPermissions.class)).isManageableByUser()) {
            HttpServletRequest servletRequest = portalControllerContext.getHttpServletRequest();
            Bundle bundle = this.bundleFactory.getBundle(servletRequest.getLocale());
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("osivia.title", bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_TITLE"));
            properties.put("theme.dyna.partial_refresh_enabled", String.valueOf(true));
            properties.put("osivia.ajaxLink", "1");
            properties.put("osivia.back.reset", String.valueOf(true));
            properties.put("osivia.navigation.reset", String.valueOf(true));
            String title = bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_MENUBAR_ITEM");
            String icon = "glyphicons glyphicons-parents";
            MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "CONFIGURATION");
            int order = 2;
            String url = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, "osivia-services-workspace-member-management-instance", properties);
            String target = null;
            String onclick = null;
            String htmlClasses = null;
            MenubarItem menubarItem = new MenubarItem(MENUBAR_ITEM_ID, title, icon, (MenubarContainer)parent, order, url, target, onclick, htmlClasses);
            menubar.add(menubarItem);
        }
    }

    public void customizeDocument(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext<? extends EcmDocument> documentContext) throws PortalException {
    }
}

