/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.plugin.portlet;

import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.portlet.PrivilegedPortletModule;
import fr.toutatice.portail.cms.nuxeo.api.workspace.WorkspaceType;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.naming.Name;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.osivia.directory.v2.model.CollabProfile;
import org.osivia.directory.v2.model.ext.WorkspaceGroupType;
import org.osivia.directory.v2.model.ext.WorkspaceRole;
import org.osivia.directory.v2.service.WorkspaceService;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.service.PersonService;

public class ManageableWorkspacesListTemplateModule
extends PrivilegedPortletModule {
    private final PersonService personService = (PersonService)DirServiceFactory.getService(PersonService.class);
    private final WorkspaceService workspaceService = (WorkspaceService)DirServiceFactory.getService(WorkspaceService.class);

    public ManageableWorkspacesListTemplateModule(PortletContext portletContext) {
        super(portletContext);
    }

    public String getFilter(PortalControllerContext portalControllerContext) {
        String filter;
        PortletRequest request = portalControllerContext.getRequest();
        String user = request.getRemoteUser();
        if (user == null) {
            filter = "1 = 0";
        } else {
            HashSet<String> identifiers;
            Name dn = this.personService.getEmptyPerson().buildDn(user);
            CollabProfile criteria = this.workspaceService.getEmptyProfile();
            criteria.setType(WorkspaceGroupType.security_group);
            criteria.setUniqueMember(Arrays.asList(dn));
            List results = this.workspaceService.findByCriteria(criteria);
            if (CollectionUtils.isEmpty((Collection)results)) {
                identifiers = null;
            } else {
                identifiers = new HashSet<String>(results.size());
                for (CollabProfile result : results) {
                    WorkspaceRole role = result.getRole();
                    if (role == null || role.getWeight() < WorkspaceRole.ADMIN.getWeight()) continue;
                    identifiers.add(result.getWorkspaceId());
                }
            }
            if (CollectionUtils.isEmpty(identifiers)) {
                filter = "1 = 0";
            } else {
                StringBuilder builder = new StringBuilder();
                builder.append("ecm:primaryType = 'Workspace' ");
                builder.append("AND webc:url IN (");
                boolean first = true;
                for (String identifier : identifiers) {
                    if (first) {
                        first = false;
                    } else {
                        builder.append(", ");
                    }
                    builder.append("'").append(identifier).append("'");
                }
                builder.append(")");
                filter = builder.toString();
            }
        }
        return filter;
    }

    protected void doView(RenderRequest request, RenderResponse response, PortletContext portletContext) throws PortletException, IOException {
        List workspaces = (List)request.getAttribute("documents");
        for (Object object : workspaces) {
            DocumentDTO workspace = (DocumentDTO)object;
            Map properties = workspace.getProperties();
            String visibility = (String)properties.get("ttcs:visibility");
            if (!StringUtils.isNotEmpty((String)visibility)) continue;
            WorkspaceType type = WorkspaceType.valueOf((String)visibility);
            properties.put("workspaceType", type);
        }
    }
}

