/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.portlet.controller;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.workspace.portlet.model.MemberManagementOptions;
import org.osivia.services.workspace.portlet.model.ResendInvitationsForm;
import org.osivia.services.workspace.portlet.service.MemberManagementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(path={"VIEW"}, params={"tab=invitations", "view=resend"})
@SessionAttributes(value={"resendInvitationsForm"})
public class MemberManagementResendInvitationsController {
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private MemberManagementService service;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) throws PortletException {
        request.setAttribute("tab", (Object)"invitations");
        request.setAttribute("view", (Object)"resend");
        return "resend-invitations/view";
    }

    @ActionMapping(value="redirectTab")
    public void redirectTab(ActionRequest request, ActionResponse response, @RequestParam(value="redirection") String redirection, SessionStatus sessionStatus) throws PortletException {
        sessionStatus.setComplete();
        response.setRenderParameter("tab", redirection);
    }

    @ActionMapping(value="submit")
    public void submit(ActionRequest request, ActionResponse response, @ModelAttribute(value="resendInvitationsForm") ResendInvitationsForm form, @ModelAttribute(value="options") MemberManagementOptions options, SessionStatus sessionStatus) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.resendInvitations(portalControllerContext, options, form);
        sessionStatus.setComplete();
        response.setRenderParameter("tab", "invitations");
    }

    @ModelAttribute(value="resendInvitationsForm")
    public ResendInvitationsForm getForm(PortletRequest request, PortletResponse response, @RequestParam(value="identifiers") String[] identifiers) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getResendInvitationsForm(portalControllerContext, identifiers);
    }

    @ModelAttribute(value="options")
    public MemberManagementOptions getOptions(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getOptions(portalControllerContext);
    }
}

