/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.directory.v2.model.CollabProfile;
import org.osivia.services.workspace.portlet.model.Invitation;
import org.osivia.services.workspace.portlet.model.InvitationState;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class UpdateInvitationsCommand
implements INuxeoCommand {
    private final List<Invitation> invitations;

    public UpdateInvitationsCommand(List<Invitation> invitations) {
        this.invitations = invitations;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        for (Invitation invitation : this.invitations) {
            ArrayList<String> localGroupIds;
            Document document = invitation.getDocument();
            if (invitation.isDeleted()) {
                documentService.remove((DocRef)document);
                continue;
            }
            if (!invitation.isEdited() || !InvitationState.SENT.equals((Object)invitation.getState())) continue;
            if (CollectionUtils.isEmpty((Collection)invitation.getLocalGroups())) {
                localGroupIds = new ArrayList<String>(0);
            } else {
                localGroupIds = new ArrayList(invitation.getLocalGroups().size());
                for (CollabProfile localGroup : invitation.getLocalGroups()) {
                    localGroupIds.add(localGroup.getCn());
                }
            }
            PropertyMap variables = document.getProperties().getMap("pi:globalVariablesValues");
            variables.set("role", invitation.getRole().getId());
            variables.set("invitationLocalGroups", StringUtils.join(localGroupIds, (String)"|"));
            variables.set("invitationMessage", invitation.getMessage());
            PropertyMap properties = new PropertyMap();
            properties.set("pi:globalVariablesValues", this.generateVariablesJSON(variables));
            documentService.update((DocRef)document, properties);
        }
        return null;
    }

    private String generateVariablesJSON(PropertyMap variables) {
        JSONArray array = new JSONArray();
        for (Map.Entry entry : variables.getMap().entrySet()) {
            JSONObject object = new JSONObject();
            object.put((Object)"name", entry.getKey());
            object.put((Object)"value", entry.getValue());
            array.add((Object)object);
        }
        return array.toString();
    }

    public String getId() {
        return null;
    }
}

