/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterException;
import fr.toutatice.portail.cms.nuxeo.api.forms.IFormsService;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.api.workspace.WorkspaceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.directory.v2.model.CollabProfile;
import org.osivia.directory.v2.model.ext.WorkspaceGroupType;
import org.osivia.directory.v2.model.ext.WorkspaceMember;
import org.osivia.directory.v2.model.ext.WorkspaceRole;
import org.osivia.directory.v2.service.PersonUpdateService;
import org.osivia.directory.v2.service.WorkspaceService;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.Notifications;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.services.workspace.portlet.model.Invitation;
import org.osivia.services.workspace.portlet.model.InvitationEditionForm;
import org.osivia.services.workspace.portlet.model.InvitationRequest;
import org.osivia.services.workspace.portlet.model.InvitationState;
import org.osivia.services.workspace.portlet.model.InvitationsCreationForm;
import org.osivia.services.workspace.portlet.model.Member;
import org.osivia.services.workspace.portlet.model.MemberObject;
import org.osivia.services.workspace.portlet.repository.DropProcedureCommand;
import org.osivia.services.workspace.portlet.repository.GetInvitationCommand;
import org.osivia.services.workspace.portlet.repository.GetInvitationsCommand;
import org.osivia.services.workspace.portlet.repository.GetWorkspaceCommand;
import org.osivia.services.workspace.portlet.repository.MemberManagementRepository;
import org.osivia.services.workspace.portlet.repository.ReloadNuxeoSessionCommand;
import org.osivia.services.workspace.portlet.repository.SetProcedureInstanceAcl;
import org.osivia.services.workspace.portlet.repository.UpdateInvitationRequestsCommand;
import org.osivia.services.workspace.portlet.repository.UpdateInvitationsCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;

@Repository
public class MemberManagementRepositoryImpl
implements MemberManagementRepository {
    private static final String CURRENT_WORKSPACE_ATTRIBUTE = "osivia.workspace.memberManagement.currentWorkspace";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private PersonUpdateService personService;
    @Autowired
    private WorkspaceService workspaceService;
    @Autowired
    private IFormsService formsService;
    @Autowired
    private IBundleFactory bundleFactory;
    @Autowired
    private INotificationsService notificationsService;
    private final Log log = LogFactory.getLog(this.getClass());

    public String getCurrentWorkspaceId(PortalControllerContext portalControllerContext) throws PortletException {
        Document workspace = this.getCurrentWorkspace(portalControllerContext);
        return workspace.getString("webc:url");
    }

    public WorkspaceType getCurrentWorkspaceType(PortalControllerContext portalControllerContext) throws PortletException {
        Document workspace = this.getCurrentWorkspace(portalControllerContext);
        String visibility = workspace.getString("ttcs:visibility");
        WorkspaceType type = StringUtils.isEmpty((String)visibility) ? null : WorkspaceType.valueOf((String)visibility);
        return type;
    }

    public int getInvitationsCount(PortalControllerContext portalControllerContext, String workspaceId) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(GetInvitationsCommand.class, new Object[]{workspaceId, InvitationState.SENT});
        Documents documents = (Documents)nuxeoController.executeNuxeoCommand(command);
        return documents.size();
    }

    public int getRequestsCount(PortalControllerContext portalControllerContext, String workspaceId) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(GetInvitationsCommand.class, new Object[]{workspaceId, InvitationState.SENT, true});
        Documents documents = (Documents)nuxeoController.executeNuxeoCommand(command);
        return documents.size();
    }

    public List<WorkspaceRole> getRoles(PortalControllerContext portalControllerContext, String workspaceId) throws PortletException {
        ArrayList<WorkspaceRole> roles = new ArrayList<WorkspaceRole>();
        String currentUser = portalControllerContext.getHttpServletRequest().getUserPrincipal().getName();
        WorkspaceMember currentMember = this.workspaceService.getMember(workspaceId, currentUser);
        WorkspaceRole currentRole = currentMember == null ? null : currentMember.getRole();
        CollabProfile criteria = this.workspaceService.getEmptyProfile();
        criteria.setWorkspaceId(workspaceId);
        criteria.setType(WorkspaceGroupType.security_group);
        List profiles = this.workspaceService.findByCriteria(criteria);
        for (CollabProfile profile : profiles) {
            WorkspaceRole role = profile.getRole();
            if (currentRole != null && currentRole.getWeight() < role.getWeight()) continue;
            roles.add(role);
        }
        return roles;
    }

    public List<CollabProfile> getLocalGroups(PortalControllerContext portalControllerContext, String workspaceId) throws PortletException {
        CollabProfile criteria = this.workspaceService.getEmptyProfile();
        criteria.setWorkspaceId(workspaceId);
        criteria.setType(WorkspaceGroupType.local_group);
        return this.workspaceService.findByCriteria(criteria);
    }

    public List<Member> getMembers(PortalControllerContext portalControllerContext, String workspaceId) throws PortletException {
        List workspaceMembers = this.workspaceService.getAllMembers(workspaceId);
        String currentUser = portalControllerContext.getHttpServletRequest().getUserPrincipal().getName();
        WorkspaceMember currentMember = this.workspaceService.getMember(workspaceId, currentUser);
        WorkspaceRole currentRole = currentMember == null ? null : currentMember.getRole();
        Map dates = this.getMemberDates(portalControllerContext);
        ArrayList<Member> members = new ArrayList<Member>(workspaceMembers.size());
        for (WorkspaceMember workspaceMember : workspaceMembers) {
            Date date = (Date)dates.get(workspaceMember.getMember().getUid());
            boolean editable = !StringUtils.equals((String)currentUser, (String)workspaceMember.getMember().getUid()) && (currentRole == null || workspaceMember.getRole() == null || currentRole.getWeight() >= workspaceMember.getRole().getWeight());
            Member member = this.getMember(workspaceMember, date, editable);
            members.add(member);
        }
        return members;
    }

    private Map<String, Date> getMemberDates(PortalControllerContext portalControllerContext) throws PortletException {
        Document workspace = this.getCurrentWorkspace(portalControllerContext);
        PropertyList members = workspace.getProperties().getList("ttcs:spaceMembers");
        HashMap<String, Date> dates = new HashMap<String, Date>(members.size());
        for (int i = 0; i < members.size(); ++i) {
            PropertyMap member = members.getMap(i);
            String user = member.getString("login");
            Date date = member.getDate("joinedDate");
            dates.put(user, date);
        }
        return dates;
    }

    protected Member getMember(WorkspaceMember workspaceMember, Date date, boolean editable) {
        Member member = (Member)this.applicationContext.getBean(Member.class, new Object[]{workspaceMember});
        String displayName = StringUtils.defaultIfBlank((String)workspaceMember.getMember().getDisplayName(), (String)workspaceMember.getMember().getUid());
        member.setDisplayName(displayName);
        String extra = workspaceMember.getMember().getMail();
        if (StringUtils.equals((String)extra, (String)displayName)) {
            extra = null;
        }
        member.setExtra(extra);
        member.setDate(date);
        member.setRole(workspaceMember.getRole());
        member.setEditable(editable);
        return member;
    }

    public void updateMember(PortalControllerContext portalControllerContext, String workspaceId, Member member) throws PortletException {
        Name dn = member.getPerson().getDn();
        if (member.isDeleted()) {
            this.workspaceService.removeMember(workspaceId, dn);
        } else if (member.isEdited()) {
            this.workspaceService.addOrModifyMember(workspaceId, dn, member.getRole());
        }
    }

    public void addToGroup(PortalControllerContext portalControllerContext, String workspaceId, List<MemberObject> members, CollabProfile group) throws PortletException {
        for (MemberObject member : members) {
            this.workspaceService.addMemberToLocalGroup(workspaceId, group.getDn(), member.getPerson().getDn());
        }
    }

    public List<Invitation> getInvitations(PortalControllerContext portalControllerContext, String workspaceId, Set<String> memberIdentifiers) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(GetInvitationsCommand.class, new Object[]{workspaceId});
        Documents documents = (Documents)nuxeoController.executeNuxeoCommand(command);
        ArrayList<Invitation> invitations = new ArrayList<Invitation>(documents.size());
        for (Document document : documents.list()) {
            PropertyMap variables = document.getProperties().getMap("pi:globalVariablesValues");
            String uid = variables.getString("uid");
            InvitationState state = InvitationState.fromName((String)variables.getString("invitationState"));
            if (!InvitationState.SENT.equals((Object)state) && (!StringUtils.isNotEmpty((String)uid) || memberIdentifiers.contains(uid))) continue;
            Invitation invitation = this.getInvitation(portalControllerContext, document);
            invitations.add(invitation);
        }
        return invitations;
    }

    protected Invitation getInvitation(PortalControllerContext portalControllerContext, Document document) throws PortletException {
        ArrayList<CollabProfile> invitationLocalGroups;
        Invitation invitation;
        PropertyMap variables = document.getProperties().getMap("pi:globalVariablesValues");
        String uid = variables.getString("uid");
        Person person = this.personService.getPerson(uid);
        if (person == null) {
            invitation = (Invitation)this.applicationContext.getBean(Invitation.class, new Object[]{uid});
            invitation.setDisplayName(uid);
        } else {
            invitation = (Invitation)this.applicationContext.getBean(Invitation.class, new Object[]{person});
            invitation.setDisplayName(StringUtils.defaultIfBlank((String)person.getDisplayName(), (String)uid));
            if (!StringUtils.equals((String)person.getMail(), (String)invitation.getDisplayName())) {
                invitation.setExtra(person.getMail());
            }
        }
        invitation.setDocument(document);
        Long dateProperty = variables.getLong("acknowledgmentDate");
        Date date = dateProperty == null ? document.getDate("dc:created") : new Date(dateProperty);
        invitation.setDate(date);
        Long resendingDateProperty = variables.getLong("invitationResendingDate");
        Date resendingDate = resendingDateProperty == null ? null : new Date(resendingDateProperty);
        invitation.setResendingDate(resendingDate);
        WorkspaceRole role = WorkspaceRole.fromId((String)variables.getString("role"));
        if (role == null) {
            role = WorkspaceRole.READER;
        }
        invitation.setRole(role);
        List<String> localGroupIds = Arrays.asList(StringUtils.split((String)StringUtils.trimToEmpty((String)variables.getString("invitationLocalGroups")), (String)"|"));
        if (CollectionUtils.isEmpty(localGroupIds)) {
            invitationLocalGroups = null;
        } else {
            invitationLocalGroups = new ArrayList<CollabProfile>(localGroupIds.size());
            CollabProfile criteria = this.workspaceService.getEmptyProfile();
            criteria.setWorkspaceId(this.getCurrentWorkspaceId(portalControllerContext));
            criteria.setType(WorkspaceGroupType.local_group);
            List workspaceLocalGroups = this.workspaceService.findByCriteria(criteria);
            for (CollabProfile localGroup : workspaceLocalGroups) {
                if (!localGroupIds.contains(localGroup.getCn())) continue;
                invitationLocalGroups.add(localGroup);
            }
        }
        invitation.setLocalGroups(invitationLocalGroups);
        String message = variables.getString("invitationMessage");
        invitation.setMessage(message);
        InvitationState state = InvitationState.fromName((String)variables.getString("invitationState"));
        invitation.setState(state);
        Long acknowledgmentDateProperty = variables.getLong("acknowledgmentDate");
        if (acknowledgmentDateProperty != null) {
            invitation.setAcknowledgmentDate(new Date(acknowledgmentDateProperty));
        }
        return invitation;
    }

    public List<Person> searchPersons(PortalControllerContext portalControllerContext, String filter, boolean tokenizer) throws PortletException {
        Person criteria = this.personService.getEmptyPerson();
        if (tokenizer) {
            criteria.setMail(filter);
        } else {
            String tokenizedFilter = filter + "*";
            String tokenizedFilterSubStr = "*" + filter + "*";
            criteria.setUid(tokenizedFilter);
            criteria.setCn(tokenizedFilter);
            criteria.setSn(tokenizedFilter);
            criteria.setGivenName(tokenizedFilter);
            criteria.setMail(tokenizedFilter);
            criteria.setDisplayName(tokenizedFilterSubStr);
        }
        return this.personService.findByCriteria(criteria, true);
    }

    public Person getPerson(PortalControllerContext portalControllerContext, String uid) throws PortletException {
        return this.personService.getPerson(uid);
    }

    public void updateInvitations(PortalControllerContext portalControllerContext, List<Invitation> invitations) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(UpdateInvitationsCommand.class, new Object[]{invitations});
        nuxeoController.executeNuxeoCommand(command);
    }

    public boolean createInvitations(PortalControllerContext portalControllerContext, String workspaceId, List<Invitation> invitations, InvitationsCreationForm form) throws PortletException {
        boolean bl;
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
        String initiator = "";
        HttpServletRequest httpServletRequest = portalControllerContext.getHttpServletRequest();
        if (httpServletRequest != null) {
            initiator = httpServletRequest.getRemoteUser();
        }
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        Document workspace = this.getCurrentWorkspace(portalControllerContext);
        List members = this.getMembers(portalControllerContext, workspaceId);
        HashMap<String, Invitation> existingInvitations = new HashMap<String, Invitation>(invitations.size());
        for (Invitation invitation : invitations) {
            if (!InvitationState.SENT.equals((Object)invitation.getState())) continue;
            existingInvitations.put(invitation.getId(), invitation);
        }
        HashSet<String> memberIdentifiers = new HashSet<String>(members.size());
        for (Member member : members) {
            memberIdentifiers.add(member.getId());
        }
        boolean bl2 = false;
        Notifications errors = new Notifications(NotificationsType.ERROR);
        Notifications warnings = new Notifications(NotificationsType.WARNING);
        ArrayList<Invitation> updatedInvitations = new ArrayList<Invitation>(form.getPendingInvitations().size());
        for (Invitation pendingInvitation : form.getPendingInvitations()) {
            ArrayList<String> localGroupIds;
            String displayName;
            String uid = pendingInvitation.getId();
            if (pendingInvitation.getPerson() == null) {
                displayName = uid;
            } else {
                displayName = StringUtils.defaultIfBlank((String)pendingInvitation.getPerson().getDisplayName(), (String)uid);
                uid = pendingInvitation.getPerson().getMail();
            }
            if (existingInvitations.containsKey(uid)) {
                Invitation existingInvitation = (Invitation)existingInvitations.get(uid);
                if (form.getRole().getWeight() <= existingInvitation.getRole().getWeight()) continue;
                existingInvitation.setRole(form.getRole());
                updatedInvitations.add(existingInvitation);
                continue;
            }
            if (memberIdentifiers.contains(uid)) {
                String message = bundle.getString("MESSAGE_WORKSPACE_INVITATIONS_MEMBER_ALREADY_EXISTS", new Object[]{displayName});
                warnings.addMessage(message);
                continue;
            }
            if (CollectionUtils.isEmpty((Collection)form.getLocalGroups())) {
                localGroupIds = new ArrayList<String>(0);
            } else {
                localGroupIds = new ArrayList(form.getLocalGroups().size());
                for (CollabProfile localGroup : form.getLocalGroups()) {
                    localGroupIds.add(localGroup.getCn());
                }
            }
            try {
                HashMap<String, String> variables = new HashMap<String, String>();
                variables.put("documentPath", workspace.getPath());
                variables.put("workspaceId", workspaceId);
                variables.put("workspaceTitle", workspace.getTitle());
                variables.put("uid", uid);
                variables.put("invitationState", InvitationState.SENT.name());
                variables.put("role", form.getRole().getId());
                variables.put("invitationLocalGroups", StringUtils.join(localGroupIds, (String)"|"));
                variables.put("invitationMessage", form.getMessage());
                variables.put("initiator", initiator);
                this.formsService.start(portalControllerContext, "invitation", variables);
                this.updateInvitationAcl(portalControllerContext, workspaceId, false, uid);
                bl = true;
            }
            catch (FormFilterException | PortalException e) {
                String message = bundle.getString("MESSAGE_WORKSPACE_INVITATIONS_CREATION_ERROR", new Object[]{displayName});
                errors.addMessage(message);
                this.log.error((Object)message, e);
            }
        }
        if (!updatedInvitations.isEmpty()) {
            this.updateInvitations(portalControllerContext, updatedInvitations);
        }
        if (!errors.getMessages().isEmpty()) {
            this.notificationsService.addNotifications(portalControllerContext, errors);
        }
        if (!warnings.getMessages().isEmpty()) {
            this.notificationsService.addNotifications(portalControllerContext, warnings);
        }
        return bl;
    }

    protected void createUser(PortalControllerContext portalControllerContext, String email, String password) throws PortletException {
        Person person = this.personService.getEmptyPerson();
        person.setUid(email);
        person.setCn(email);
        person.setSn(email);
        person.setMail(email);
        this.personService.create(person);
        this.personService.updatePassword(person, password);
    }

    public List<InvitationRequest> getInvitationRequests(PortalControllerContext portalControllerContext, String workspaceId, Set<String> memberIdentifiers) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(GetInvitationsCommand.class, new Object[]{workspaceId, true});
        Documents documents = (Documents)nuxeoController.executeNuxeoCommand(command);
        ArrayList<InvitationRequest> requests = new ArrayList<InvitationRequest>(documents.size());
        for (Document document : documents.list()) {
            PropertyMap variables = document.getProperties().getMap("pi:globalVariablesValues");
            String uid = variables.getString("uid");
            InvitationState state = InvitationState.fromName((String)variables.getString("invitationState"));
            if (!InvitationState.SENT.equals((Object)state) && (!StringUtils.isNotEmpty((String)uid) || memberIdentifiers.contains(uid))) continue;
            InvitationRequest request = this.getInvitationRequest(uid, document, variables);
            request.setDocument(document);
            requests.add(request);
        }
        return requests;
    }

    protected InvitationRequest getInvitationRequest(String uid, Document document, PropertyMap variables) {
        InvitationRequest request;
        Person person = this.personService.getPerson(uid);
        if (person == null) {
            request = (InvitationRequest)this.applicationContext.getBean(InvitationRequest.class, new Object[]{uid});
            request.setDisplayName(uid);
        } else {
            request = (InvitationRequest)this.applicationContext.getBean(InvitationRequest.class, new Object[]{person});
            request.setDisplayName(StringUtils.defaultIfBlank((String)person.getDisplayName(), (String)uid));
            if (!StringUtils.equals((String)person.getMail(), (String)request.getDisplayName())) {
                request.setExtra(person.getMail());
            }
        }
        Date date = document.getDate("dc:created");
        request.setDate(date);
        WorkspaceRole role = WorkspaceRole.fromId((String)variables.getString("role"));
        if (role == null) {
            role = WorkspaceRole.READER;
        }
        request.setRole(role);
        InvitationState state = InvitationState.fromName((String)variables.getString("invitationState"));
        request.setState(state);
        String userMessage = variables.getString("userMessage");
        request.setUserMessage(userMessage);
        return request;
    }

    public void updateInvitationRequests(PortalControllerContext portalControllerContext, String workspaceId, List<InvitationRequest> invitationRequests) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(UpdateInvitationRequestsCommand.class, new Object[]{portalControllerContext, invitationRequests});
        nuxeoController.executeNuxeoCommand(command);
    }

    public String getHelp(PortalControllerContext portalControllerContext, String property) throws PortletException {
        String help;
        String location = null;
        if (StringUtils.isNotBlank((String)property)) {
            location = System.getProperty(property);
        }
        if (StringUtils.isBlank(location)) {
            help = null;
        } else {
            NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
            String path = location.startsWith("/") ? location : NuxeoController.webIdToFetchPath((String)location);
            try {
                NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
                Document document = documentContext.getDoc();
                help = nuxeoController.transformHTMLContent(StringUtils.trimToEmpty((String)document.getString("note:note")));
            }
            catch (NuxeoException e) {
                if (e.getErrorCode() == NuxeoException.ERROR_NOTFOUND) {
                    help = null;
                }
                throw e;
            }
        }
        return help;
    }

    public void acceptInvitation(NuxeoController nuxeoController, Map<String, String> variables) {
        String workspaceId = variables.get("workspaceId");
        String memberId = variables.get("uid");
        WorkspaceRole role = WorkspaceRole.fromId((String)variables.get("role"));
        if (role == null) {
            role = WorkspaceRole.READER;
        }
        List<String> localGroupIds = Arrays.asList(StringUtils.split((String)StringUtils.trimToEmpty((String)variables.get("invitationLocalGroups")), (String)"|"));
        Name memberDn = this.personService.getEmptyPerson().buildDn(memberId);
        this.workspaceService.addOrModifyMember(workspaceId, memberDn, role);
        for (String localGroupId : localGroupIds) {
            try {
                this.workspaceService.addMemberToLocalGroup(workspaceId, localGroupId, memberId);
            }
            catch (Exception exception) {}
        }
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(ReloadNuxeoSessionCommand.class);
        nuxeoController.executeNuxeoCommand(command);
    }

    public List<Document> getPendingInvitations(PortalControllerContext portalControllerContext, String uid) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        HashSet<String> identifiers = new HashSet<String>(1);
        identifiers.add(uid);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(GetInvitationsCommand.class, new Object[]{null, InvitationState.SENT, identifiers});
        Documents documents = (Documents)nuxeoController.executeNuxeoCommand(command);
        return documents.list();
    }

    public void createInvitationRequest(PortalControllerContext portalControllerContext, String workspaceId, String uid, String userMessage) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        try {
            Document workspace = this.getWorkspace(portalControllerContext, workspaceId);
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("documentPath", workspace.getPath());
            variables.put("workspaceId", workspaceId);
            variables.put("workspaceTitle", workspace.getTitle());
            variables.put("uid", uid);
            variables.put("invitationState", InvitationState.SENT.name());
            variables.put("userMessage", userMessage);
            this.formsService.start(portalControllerContext, "invitation-request", variables);
            this.updateInvitationAcl(portalControllerContext, workspaceId, true, uid);
            String message = bundle.getString("MESSAGE_WORKSPACE_REQUEST_CREATION_SUCCESS");
            this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
        }
        catch (FormFilterException | PortalException e) {
            String message = bundle.getString("MESSAGE_WORKSPACE_REQUEST_CREATION_ERROR");
            this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.ERROR);
            this.log.error((Object)message, e);
        }
    }

    public Document getCurrentWorkspace(PortalControllerContext portalControllerContext) {
        PortletRequest request = portalControllerContext.getRequest();
        Document workspace = (Document)request.getAttribute(CURRENT_WORKSPACE_ATTRIBUTE);
        if (workspace == null) {
            NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
            String basePath = nuxeoController.getBasePath();
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(basePath, true);
            workspace = documentContext.getDoc();
            request.setAttribute(CURRENT_WORKSPACE_ATTRIBUTE, (Object)workspace);
        }
        return workspace;
    }

    protected Document getWorkspace(PortalControllerContext portalControllerContext, String workspaceId) {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(GetWorkspaceCommand.class, new Object[]{workspaceId});
        Documents documents = (Documents)nuxeoController.executeNuxeoCommand(command);
        Document workspace = documents.size() == 1 ? documents.get(0) : null;
        return workspace;
    }

    protected void updateInvitationAcl(PortalControllerContext portalControllerContext, String workspaceId, boolean request, String uid) {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
        ArrayList groups = new ArrayList();
        CollabProfile criteria = this.workspaceService.getEmptyProfile();
        criteria.setWorkspaceId(workspaceId);
        criteria.setRole(WorkspaceRole.ADMIN);
        groups.addAll(this.workspaceService.findByCriteria(criteria));
        criteria.setRole(WorkspaceRole.OWNER);
        groups.addAll(this.workspaceService.findByCriteria(criteria));
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(SetProcedureInstanceAcl.class, new Object[]{workspaceId, request, uid, groups});
        nuxeoController.executeNuxeoCommand(command);
    }

    public InvitationEditionForm getInvitationEditionForm(PortalControllerContext portalControllerContext, String path) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(GetInvitationCommand.class, new Object[]{path});
        Document document = (Document)nuxeoController.executeNuxeoCommand(command);
        Invitation invitation = this.getInvitation(portalControllerContext, document);
        InvitationEditionForm form = (InvitationEditionForm)this.applicationContext.getBean(InvitationEditionForm.class, new Object[]{path});
        form.setInvitation(invitation);
        return form;
    }

    public void resendInvitation(PortalControllerContext portalControllerContext, InvitationEditionForm form, Date date) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        boolean ok = this.resendInvitation(portalControllerContext, form.getInvitation(), form.getMessage(), date, bundle);
        if (ok) {
            String message = bundle.getString("MESSAGE_WORKSPACE_INVITATION_RESENDING_SUCCESS");
            this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
        } else {
            String message = bundle.getString("MESSAGE_WORKSPACE_INVITATION_RESENDING_ERROR");
            this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.ERROR);
        }
    }

    protected boolean resendInvitation(PortalControllerContext portalControllerContext, Invitation invitation, String message, Date date, Bundle bundle) {
        boolean status;
        HashMap<String, String> variables;
        Document procedureInstance = invitation.getDocument();
        PropertyMap procedureInstanceProperties = procedureInstance.getProperties();
        PropertyMap globalVariablesValues = procedureInstanceProperties.getMap("pi:globalVariablesValues");
        if (globalVariablesValues == null || globalVariablesValues.isEmpty()) {
            variables = new HashMap<String, String>(0);
        } else {
            variables = new HashMap(globalVariablesValues.size());
            for (String key : globalVariablesValues.getKeys()) {
                variables.put(key, globalVariablesValues.getString(key));
            }
        }
        variables.put("invitationResendingDate", String.valueOf(date.getTime()));
        variables.put("invitationMessage", message);
        PropertyMap taskProperties = procedureInstanceProperties.getMap("pi:task");
        try {
            this.formsService.proceed(portalControllerContext, taskProperties, "resend", variables);
            status = true;
        }
        catch (FormFilterException | PortalException e) {
            String errorMessage = bundle.getString("MESSAGE_WORKSPACE_INVITATION_RESENDING_ERROR");
            this.log.error((Object)errorMessage, e);
            status = false;
        }
        return status;
    }

    public boolean resendInvitations(PortalControllerContext portalControllerContext, List<Invitation> invitations, String message, Date date) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        boolean status = true;
        for (Invitation invitation : invitations) {
            boolean result = this.resendInvitation(portalControllerContext, invitation, message, date, bundle);
            status &= result;
        }
        return status;
    }

    public void dropInvitation(PortalControllerContext portalControllerContext, String invitationPath) {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        boolean status = true;
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(DropProcedureCommand.class, new Object[]{invitationPath});
        nuxeoController.executeNuxeoCommand(command);
    }
}

