/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.portlet.configuration;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.forms.IFormsService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoServiceFactory;
import javax.annotation.PostConstruct;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import org.osivia.directory.v2.service.PersonUpdateService;
import org.osivia.directory.v2.service.WorkspaceService;
import org.osivia.portal.api.batch.IBatchService;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.portlet.PortletAppUtils;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.web.portlet.multipart.CommonsPortletMultipartResolver;
import org.springframework.web.portlet.multipart.PortletMultipartResolver;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.JstlView;

@Configuration
@ComponentScan(basePackages={"org.osivia.services.workspace.portlet"})
public class MemberManagementConfiguration
extends CMSPortlet {
    public static final Long MAX_UPLOAD_SIZE_PER_FILE = 0x100000L;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private PortletConfig portletConfig;

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
        PortletAppUtils.registerApplication((PortletConfig)this.portletConfig, (Object)this.applicationContext);
    }

    @Bean
    public InternalResourceViewResolver getViewResolver() {
        InternalResourceViewResolver viewResolver = new InternalResourceViewResolver();
        viewResolver.setCache(true);
        viewResolver.setViewClass(JstlView.class);
        viewResolver.setPrefix("/WEB-INF/jsp/");
        viewResolver.setSuffix(".jsp");
        return viewResolver;
    }

    @Bean(name={"messageSource"})
    public ResourceBundleMessageSource getMessageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasename("Resource");
        return messageSource;
    }

    @Bean
    public IPortalUrlFactory getPortalUrlFactory() {
        return (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
    }

    @Bean
    public PersonUpdateService getPersonService() {
        return (PersonUpdateService)DirServiceFactory.getService(PersonUpdateService.class);
    }

    @Bean
    public WorkspaceService getWorkspaceService() {
        return (WorkspaceService)DirServiceFactory.getService(WorkspaceService.class);
    }

    @Bean
    public IFormsService getFormsService() {
        return NuxeoServiceFactory.getFormsService();
    }

    @Bean
    public IBundleFactory getBundleFactory() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        return internationalizationService.getBundleFactory(this.getClass().getClassLoader(), this.applicationContext);
    }

    @Bean
    public INotificationsService getNotificationService() {
        return (INotificationsService)Locator.findMBean(INotificationsService.class, (String)"osivia:service=NotificationsService");
    }

    @Bean(name={"portletMultipartResolver"})
    public PortletMultipartResolver getMultipartResolver() {
        CommonsPortletMultipartResolver multipartResolver = new CommonsPortletMultipartResolver();
        multipartResolver.setDefaultEncoding("UTF-8");
        multipartResolver.setMaxUploadSizePerFile(MAX_UPLOAD_SIZE_PER_FILE.longValue());
        return multipartResolver;
    }

    @Bean
    public IBatchService getBatchService() {
        return (IBatchService)Locator.findMBean(IBatchService.class, (String)"osivia:service=BatchService");
    }

    @Bean
    public INuxeoService getNuxeoService() {
        return (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
    }
}

