/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.portlet.service;

import fr.gouv.education.foad.portlet.model.FolderTask;
import fr.gouv.education.foad.portlet.model.ServiceTask;
import fr.gouv.education.foad.portlet.model.Task;
import fr.gouv.education.foad.portlet.model.Taskbar;
import fr.gouv.education.foad.portlet.repository.TaskbarRepository;
import fr.gouv.education.foad.portlet.service.TaskbarService;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.panels.PanelPlayer;
import org.osivia.portal.api.taskbar.ITaskbarService;
import org.osivia.portal.api.taskbar.TaskbarItemType;
import org.osivia.portal.api.taskbar.TaskbarTask;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class TaskbarServiceImpl
implements TaskbarService {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private TaskbarRepository repository;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;
    @Autowired
    private ITaskbarService taskbarService;
    @Autowired
    private IBundleFactory bundleFactory;
    @Autowired
    private INotificationsService notificationsService;

    public Taskbar getTaskbar(PortalControllerContext portalControllerContext) throws PortletException {
        ArrayList<TaskbarTask> services;
        ArrayList<TaskbarTask> folders;
        String activeId;
        PortletRequest request = portalControllerContext.getRequest();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        List navigationTasks = this.repository.getNavigationTasks(portalControllerContext);
        try {
            activeId = this.taskbarService.getActiveId(portalControllerContext);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        if (CollectionUtils.isEmpty((Collection)navigationTasks)) {
            folders = null;
            services = null;
        } else {
            folders = new ArrayList<TaskbarTask>();
            services = new ArrayList<TaskbarTask>();
            for (TaskbarTask navigationTask : navigationTasks) {
                if (navigationTask.isDisabled() || navigationTask.isHidden()) continue;
                if (TaskbarItemType.CMS.equals((Object)navigationTask.getType()) && "Folder".equals(navigationTask.getDocumentType())) {
                    folders.add(navigationTask);
                    continue;
                }
                if (TaskbarItemType.CMS.equals((Object)navigationTask.getType()) && "Room".equals(navigationTask.getDocumentType())) continue;
                services.add(navigationTask);
            }
        }
        Taskbar taskbar = (Taskbar)this.applicationContext.getBean(Taskbar.class);
        taskbar.setFolders(this.createTasks(portalControllerContext, bundle, activeId, folders, FolderTask.class));
        taskbar.setServices(this.createTasks(portalControllerContext, bundle, activeId, services, ServiceTask.class));
        List administration = this.repository.getAdministration(portalControllerContext);
        taskbar.setAdministration(administration);
        return taskbar;
    }

    private <T extends Task> List<T> createTasks(PortalControllerContext portalControllerContext, Bundle bundle, String activeId, List<TaskbarTask> navigationTasks, Class<T> clazz) throws PortletException {
        ArrayList<Task> tasks;
        if (CollectionUtils.isEmpty(navigationTasks)) {
            tasks = null;
        } else {
            tasks = new ArrayList<Task>(navigationTasks.size());
            for (TaskbarTask navigationTask : navigationTasks) {
                Task task = this.createTask(portalControllerContext, bundle, activeId, navigationTask, clazz);
                tasks.add(task);
            }
        }
        return tasks;
    }

    private <T extends Task> T createTask(PortalControllerContext portalControllerContext, Bundle bundle, String activeId, TaskbarTask navigationTask, Class<T> clazz) throws PortletException {
        String url;
        Task task = (Task)this.applicationContext.getBean(clazz);
        String displayName = StringUtils.isEmpty((String)navigationTask.getTitle()) ? bundle.getString(navigationTask.getKey(), navigationTask.getCustomizedClassLoader(), new Object[0]) : navigationTask.getTitle();
        task.setDisplayName(displayName);
        if (navigationTask.getPlayer() != null) {
            PanelPlayer player = navigationTask.getPlayer();
            HashMap<String, String> properties = new HashMap<String, String>();
            if (player.getProperties() != null) {
                properties.putAll(player.getProperties());
            }
            properties.put("osivia.taskbar.id", navigationTask.getId());
            if (StringUtils.isNotEmpty((String)displayName)) {
                properties.put("osivia.title", displayName);
            }
            properties.put("osivia.back.reset", String.valueOf(true));
            properties.put("osivia.navigation.reset", String.valueOf(true));
            try {
                url = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, player.getInstance(), properties);
            }
            catch (PortalException e) {
                throw new PortletException((Throwable)e);
            }
        } else if (StringUtils.isNotEmpty((String)navigationTask.getPath())) {
            String path = navigationTask.getPath();
            url = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, path, null, null, "taskbar", null, null, "1", null);
        } else {
            url = "#";
        }
        task.setUrl(url);
        boolean active = StringUtils.equals((String)activeId, (String)navigationTask.getId());
        task.setActive(active);
        if (active && task instanceof FolderTask) {
            FolderTask folder = (FolderTask)task;
            folder.setPath(navigationTask.getPath());
            this.repository.generateFolderNavigationTree(portalControllerContext, folder);
        }
        if (task instanceof ServiceTask) {
            ServiceTask service = (ServiceTask)task;
            String icon = navigationTask.getIcon();
            service.setIcon(icon);
            String type = StringUtils.lowerCase((String)navigationTask.getId());
            service.setType(type);
        }
        return (T)task;
    }

    public void drop(PortalControllerContext portalControllerContext, List<String> sourceIds, String targetId) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        ActionResponse response = (ActionResponse)portalControllerContext.getResponse();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        try {
            this.repository.moveDocuments(portalControllerContext, sourceIds, targetId);
            String message = bundle.getString("TASKBAR_MOVE_SUCCESS_MESSAGE");
            this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
        }
        catch (NuxeoException e) {
            String message = bundle.getString("TASKBAR_MOVE_WARNING_MESSAGE");
            this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.WARNING);
        }
        request.setAttribute("osivia.updateContents", (Object)"true");
        response.setRenderParameter("dnd-update", String.valueOf(System.currentTimeMillis()));
    }

    public JSONArray getFolderChildren(PortalControllerContext portalControllerContext, String path) throws PortletException {
        SortedSet children = this.repository.getFolderChildren(portalControllerContext, path);
        JSONArray array = new JSONArray();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            for (FolderTask child : children) {
                JSONObject object = new JSONObject();
                object.put((Object)"title", (Object)child.getDisplayName());
                object.put((Object)"href", (Object)child.getUrl());
                object.put((Object)"folder", (Object)child.isFolder());
                object.put((Object)"lazy", (Object)child.isLazy());
                object.put((Object)"path", (Object)child.getPath());
                array.add((Object)object);
            }
        }
        return array;
    }
}

