/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.helpers;

import java.io.Serializable;
import java.security.Principal;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.core.Events;
import org.jboss.seam.international.LocaleSelector;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.rest.RestHelper;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.ecm.webapp.dashboard.DashboardNavigationHelper;
import org.nuxeo.ecm.webapp.helpers.ConversationIdGenerator;

@Name(value="startupHelper")
@Scope(value=ScopeType.SESSION)
@Install(precedence=10)
public class StartupHelper
implements Serializable {
    protected static final String SERVERS_VIEW = "view_servers";
    protected static final String DOMAINS_VIEW = "view_domains";
    protected static final String DOMAIN_TYPE = "Domain";
    protected static final String DOCUMENT_MANAGEMENT_TAB = "MAIN_TABS:documents";
    private static final long serialVersionUID = 3248972387619873245L;
    private static final Log log = LogFactory.getLog(StartupHelper.class);
    @In(create=true)
    protected transient RepositoryManager repositoryManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient WebActions webActions;
    @In
    protected transient Context sessionContext;
    @In(create=true)
    protected DashboardNavigationHelper dashboardNavigationHelper;
    @In(create=true)
    ConversationIdGenerator conversationIdGenerator;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    @Deprecated
    protected transient LocaleSelector localeSelector;
    @In(create=true)
    protected transient RestHelper restHelper;

    public String initServerAndFindStartupPage() throws ClientException {
        DocumentModel rootDocument;
        this.setupCurrentUser();
        if (this.navigationContext.getCurrentServerLocation() == null) {
            RepositoryLocation repLoc = new RepositoryLocation(this.repositoryManager.getDefaultRepositoryName());
            this.navigationContext.setCurrentServerLocation(repLoc);
        }
        if (this.documentManager == null) {
            this.documentManager = this.navigationContext.getOrCreateDocumentManager();
        }
        if (Events.exists()) {
            Events.instance().raiseEvent("org.nuxeo.ecm.web.userSessionStarted", new Object[]{this.documentManager});
        }
        if (!this.documentManager.hasPermission((rootDocument = this.documentManager.getRootDocument()).getRef(), "ReadChildren")) {
            return this.dashboardNavigationHelper.navigateToDashboard();
        }
        this.webActions.setCurrentTabIds(DOCUMENT_MANAGEMENT_TAB);
        if (this.repositoryManager.getRepositoryNames().size() > 1) {
            return SERVERS_VIEW;
        }
        return DOMAINS_VIEW;
    }

    @Begin(id="#{conversationIdGenerator.nextMainConversationId}", join=true)
    public String initDomainAndFindStartupPage(String domainTitle, String viewId) {
        try {
            String result = this.initServerAndFindStartupPage();
            HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
            if (SERVERS_VIEW.equals(result)) {
                return result;
            }
            String query = "SELECT * FROM Domain WHERE ecm:mixinType <> 'HiddenInNavigation' AND ecm:currentLifeCycleState <> 'deleted' AND ecm:isCheckedInVersion = 0  AND ecm:isProxy = 0 ";
            DocumentModelList domains = this.documentManager.query(query);
            if (domains.size() == 1) {
                this.webActions.setCurrentTabIds(DOCUMENT_MANAGEMENT_TAB);
                return this.navigationContext.navigateToDocument((DocumentModel)domains.get(0), viewId);
            }
            DocumentModel rootDocument = this.documentManager.getRootDocument();
            if (this.documentManager.hasPermission(rootDocument.getRef(), "ReadChildren")) {
                this.webActions.setCurrentTabIds(DOCUMENT_MANAGEMENT_TAB);
                this.navigationContext.navigateToDocument(rootDocument);
                return DOMAINS_VIEW;
            }
            return result;
        }
        catch (ClientException e) {
            log.error((Object)("error while initializing the Seam context with a CoreSession instance: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public void setupCurrentUser() {
        Principal currentUser = FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal();
        this.sessionContext.set("currentUser", (Object)currentUser);
    }
}

