/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces;

public enum JsfVersion {
    JSF_2_0,
    JSF_2_1,
    JSF_2_2;

    private static final JsfVersion CURRENT_VERSION;

    private static JsfVersion detectVersion() {
        try {
            Class.forName("javax.faces.lifecycle.ClientWindow");
            return JSF_2_2;
        }
        catch (ClassNotFoundException e1) {
            try {
                Class.forName("javax.faces.view.facelets.FaceletCacheFactory");
                return JSF_2_1;
            }
            catch (ClassNotFoundException e2) {
                return JSF_2_0;
            }
        }
    }

    public static JsfVersion getCurrent() {
        return CURRENT_VERSION;
    }

    public boolean isCompliantWith(JsfVersion version) {
        if (version == null) {
            throw new IllegalArgumentException("version must be provided");
        }
        return this.ordinal() >= version.ordinal();
    }

    static {
        CURRENT_VERSION = JsfVersion.detectVersion();
    }
}

