/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter.office;

import java.io.File;
import org.artofsolving.jodconverter.office.OfficeConnectionProtocol;
import org.artofsolving.jodconverter.office.OfficeManager;
import org.artofsolving.jodconverter.office.OfficeUtils;
import org.artofsolving.jodconverter.office.ProcessPoolOfficeManager;
import org.artofsolving.jodconverter.office.UnoUrl;
import org.artofsolving.jodconverter.process.MacProcessManager;
import org.artofsolving.jodconverter.process.ProcessManager;
import org.artofsolving.jodconverter.process.PureJavaProcessManager;
import org.artofsolving.jodconverter.process.UnixProcessManager;
import org.artofsolving.jodconverter.process.WindowsProcessManager;
import org.artofsolving.jodconverter.util.PlatformUtils;

public class DefaultOfficeManagerConfiguration {
    private File officeHome = OfficeUtils.getDefaultOfficeHome();
    private OfficeConnectionProtocol connectionProtocol = OfficeConnectionProtocol.SOCKET;
    private int[] portNumbers = new int[]{2002};
    private String[] pipeNames = new String[]{"office"};
    private File templateProfileDir = null;
    private long taskQueueTimeout = 30000L;
    private long taskExecutionTimeout = 120000L;
    private int maxTasksPerProcess = 200;
    private boolean useGnuStyleLongOptions;
    private ProcessManager processManager = null;

    public DefaultOfficeManagerConfiguration setOfficeHome(String officeHome) throws NullPointerException, IllegalArgumentException {
        this.checkArgumentNotNull("officeHome", officeHome);
        return this.setOfficeHome(new File(officeHome));
    }

    public DefaultOfficeManagerConfiguration setOfficeHome(File officeHome) throws NullPointerException, IllegalArgumentException {
        this.checkArgumentNotNull("officeHome", officeHome);
        this.checkArgument("officeHome", officeHome.isDirectory(), "must exist and be a directory");
        this.officeHome = officeHome;
        return this;
    }

    public DefaultOfficeManagerConfiguration setConnectionProtocol(OfficeConnectionProtocol connectionProtocol) throws NullPointerException {
        this.checkArgumentNotNull("connectionProtocol", (Object)connectionProtocol);
        this.connectionProtocol = connectionProtocol;
        return this;
    }

    public DefaultOfficeManagerConfiguration setPortNumber(int portNumber) {
        this.portNumbers = new int[]{portNumber};
        return this;
    }

    public DefaultOfficeManagerConfiguration setPortNumbers(int ... portNumbers) throws NullPointerException, IllegalArgumentException {
        this.checkArgumentNotNull("portNumbers", portNumbers);
        this.checkArgument("portNumbers", portNumbers.length > 0, "must not be empty");
        this.portNumbers = portNumbers;
        return this;
    }

    public DefaultOfficeManagerConfiguration setPipeName(String pipeName) throws NullPointerException {
        this.checkArgumentNotNull("pipeName", pipeName);
        this.pipeNames = new String[]{pipeName};
        return this;
    }

    public DefaultOfficeManagerConfiguration setPipeNames(String ... pipeNames) throws NullPointerException, IllegalArgumentException {
        this.checkArgumentNotNull("pipeNames", pipeNames);
        this.checkArgument("pipeNames", pipeNames.length > 0, "must not be empty");
        this.pipeNames = pipeNames;
        return this;
    }

    public DefaultOfficeManagerConfiguration setTemplateProfileDir(File templateProfileDir) throws IllegalArgumentException {
        if (templateProfileDir != null) {
            this.checkArgument("templateProfileDir", templateProfileDir.isDirectory(), "must exist and be a directory");
        }
        this.templateProfileDir = templateProfileDir;
        return this;
    }

    public DefaultOfficeManagerConfiguration setTaskQueueTimeout(long taskQueueTimeout) {
        this.taskQueueTimeout = taskQueueTimeout;
        return this;
    }

    public DefaultOfficeManagerConfiguration setTaskExecutionTimeout(long taskExecutionTimeout) {
        this.taskExecutionTimeout = taskExecutionTimeout;
        return this;
    }

    public DefaultOfficeManagerConfiguration setMaxTasksPerProcess(int maxTasksPerProcess) {
        this.maxTasksPerProcess = maxTasksPerProcess;
        return this;
    }

    public DefaultOfficeManagerConfiguration setProcessManager(ProcessManager processManager) throws NullPointerException {
        this.checkArgumentNotNull("processManager", processManager);
        this.processManager = processManager;
        return this;
    }

    public OfficeManager buildOfficeManager() throws IllegalStateException {
        String forceOptionStyle;
        if (!this.officeHome.isDirectory()) {
            throw new IllegalStateException("officeHome doesn't exist or is not a directory: " + this.officeHome);
        }
        if (!OfficeUtils.getOfficeExecutable(this.officeHome).isFile()) {
            throw new IllegalStateException("invalid officeHome: couldn't find " + OfficeUtils.getOfficeExecutable(this.officeHome));
        }
        if (this.templateProfileDir != null && !this.isValidProfileDir(this.templateProfileDir)) {
            throw new IllegalStateException("invalid templateProfileDir: " + this.templateProfileDir);
        }
        if (this.processManager == null) {
            this.processManager = this.findBestProcessManager();
        }
        if ((forceOptionStyle = System.getProperty("jod.office.gnustyleoptions.force")) != null) {
            this.useGnuStyleLongOptions = Boolean.parseBoolean(forceOptionStyle);
        }
        int numInstances = this.connectionProtocol == OfficeConnectionProtocol.PIPE ? this.pipeNames.length : this.portNumbers.length;
        UnoUrl[] unoUrls = new UnoUrl[numInstances];
        for (int i = 0; i < numInstances; ++i) {
            unoUrls[i] = this.connectionProtocol == OfficeConnectionProtocol.PIPE ? UnoUrl.pipe(this.pipeNames[i]) : UnoUrl.socket(this.portNumbers[i]);
        }
        return new ProcessPoolOfficeManager(this.officeHome, unoUrls, this.templateProfileDir, this.taskQueueTimeout, this.taskExecutionTimeout, this.maxTasksPerProcess, this.processManager, this.useGnuStyleLongOptions);
    }

    private ProcessManager findBestProcessManager() {
        if (PlatformUtils.isLinux()) {
            return new UnixProcessManager();
        }
        if (PlatformUtils.isMac()) {
            return new MacProcessManager();
        }
        if (PlatformUtils.isWindows()) {
            WindowsProcessManager windowsProcessManager = new WindowsProcessManager();
            return windowsProcessManager.isUsable() ? windowsProcessManager : new PureJavaProcessManager();
        }
        return new PureJavaProcessManager();
    }

    private void checkArgumentNotNull(String argName, Object argValue) throws NullPointerException {
        if (argValue == null) {
            throw new NullPointerException(argName + " must not be null");
        }
    }

    private void checkArgument(String argName, boolean condition, String message) throws IllegalArgumentException {
        if (!condition) {
            throw new IllegalArgumentException(argName + " " + message);
        }
    }

    private boolean isValidProfileDir(File profileDir) {
        File setupXcu = new File(profileDir, "user/registry/data/org/openoffice/Setup.xcu");
        return setupXcu.exists();
    }

    public void setUseGnuStyleLongOptions(boolean useGnuStyleLongOptions) {
        this.useGnuStyleLongOptions = useGnuStyleLongOptions;
    }
}

