/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.routing.api.LockableDocumentRoute;

public class LockableDocumentRouteImpl
implements LockableDocumentRoute {
    protected final DocumentModel doc;
    private static final long serialVersionUID = 1L;

    public LockableDocumentRouteImpl(DocumentModel document) {
        this.doc = document;
    }

    public boolean isLocked(CoreSession session) throws ClientException {
        return session.getLockInfo(this.doc.getRef()) != null;
    }

    public boolean isLockedByCurrentUser(CoreSession session) throws ClientException {
        Lock lockInfo = session.getLockInfo(this.doc.getRef());
        if (lockInfo == null) {
            return false;
        }
        String lockOwner = lockInfo.getOwner();
        NuxeoPrincipal userName = (NuxeoPrincipal)session.getPrincipal();
        return userName.getName().equals(lockOwner);
    }

    public void lockDocument(CoreSession session) throws ClientException {
        session.setLock(this.doc.getRef());
    }

    public void unlockDocument(CoreSession session) throws ClientException {
        DocumentRef ref = this.doc.getRef();
        session.removeLock(ref);
    }

    public String getLockOwner(CoreSession session) {
        return session.getPrincipal().getName();
    }
}

