/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.security.Principal;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.impl.AbstractFileSystemItemFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractSyncRootFolderItemFactory
extends AbstractFileSystemItemFactory {
    private static final Log log = LogFactory.getLog(AbstractSyncRootFolderItemFactory.class);

    protected abstract FolderItem getParentItem(DocumentModel var1) throws ClientException;

    @Override
    public void handleParameters(Map<String, String> parameters) throws ClientException {
        if (!parameters.isEmpty()) {
            throw new IllegalArgumentException("Parameter map is not empty whereas no parameters are contributed to the factory.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Factory %s has no parameters to handle.", this.getName()));
        }
    }

    @Override
    public boolean isFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint) throws ClientException {
        Principal principal;
        NuxeoDriveManager nuxeoDriveManager;
        boolean isSyncRoot;
        if (!doc.isFolder()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Document %s is not Folderish, it cannot be adapted as a FileSystemItem.", doc.getId()));
            }
            return false;
        }
        if (doc.isVersion()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Document %s is a version, it cannot be adapted as a FileSystemItem.", doc.getId()));
            }
            return false;
        }
        if (doc.isProxy()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Document %s is a proxy, it cannot be adapted as a FileSystemItem.", doc.getId()));
            }
            return false;
        }
        if (doc.hasFacet("HiddenInNavigation")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Document %s is HiddenInNavigation, it cannot be adapted as a FileSystemItem.", doc.getId()));
            }
            return false;
        }
        if (!includeDeleted && "deleted".equals(doc.getCurrentLifeCycleState())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Document %s is in the '%s' life cycle state, it cannot be adapted as a FileSystemItem.", doc.getId(), "deleted"));
            }
            return false;
        }
        if (!relaxSyncRootConstraint && !(isSyncRoot = (nuxeoDriveManager = (NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class)).isSynchronizationRoot(principal = doc.getCoreSession().getPrincipal(), doc))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Document %s is not a registered synchronization root for user %s, it cannot be adapted as a FileSystemItem.", doc.getId(), principal.getName()));
            }
            return false;
        }
        return true;
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted) throws ClientException {
        return this.getFileSystemItem(doc, this.getParentItem(doc), includeDeleted);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint) throws ClientException {
        return this.getFileSystemItem(doc, this.getParentItem(doc), includeDeleted, relaxSyncRootConstraint);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint, boolean getLockInfo) throws ClientException {
        return this.getFileSystemItem(doc, this.getParentItem(doc), includeDeleted, relaxSyncRootConstraint, getLockInfo);
    }
}

