/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.listener;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.listener.ToutaticeChangeCreationPropertiesListener;
import fr.toutatice.ecm.platform.core.listener.ToutaticeDocumentEventListenerHelper;
import java.io.Serializable;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.PostCommitFilteringEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventImpl;
import org.nuxeo.runtime.api.Framework;

public class ToutaticeBulkDocumentCopiedListener
implements PostCommitFilteringEventListener {
    public static final String BLOCK = "block";
    private static final Log log = LogFactory.getLog(ToutaticeBulkDocumentCopiedListener.class);
    private static EventService evtService;

    public static EventService getEventService() {
        if (evtService == null) {
            evtService = (EventService)Framework.getService(EventService.class);
        }
        return evtService;
    }

    public boolean acceptEvent(Event event) {
        return "documentCreatedByCopy".equals(event.getName());
    }

    public void handleEvent(EventBundle events) throws ClientException {
        DocumentModel srcDoc;
        DocumentEventContext docCtx;
        Event event = events.peek();
        EventContext context = event.getContext();
        if (DocumentEventContext.class.isInstance(context) && BooleanUtils.isNotTrue((Boolean)((Boolean)(docCtx = (DocumentEventContext)context).getProperty(BLOCK))) && (srcDoc = docCtx.getSourceDocument()).isFolder() && ToutaticeDocumentEventListenerHelper.isAlterableDocument(srcDoc) && !ToutaticeChangeCreationPropertiesListener.block(docCtx)) {
            CoreSession session = docCtx.getCoreSession();
            DocumentModelListImpl docs = new DocumentModelListImpl();
            docs.add((Object)srcDoc);
            if (session.exists(srcDoc.getRef())) {
                try {
                    this.fireCreatedByCopy(docCtx, session, event, (DocumentModelList)docs);
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
                session.save();
            }
        }
    }

    protected void fireCreatedByCopy(DocumentEventContext docCtx, CoreSession session, Event event, DocumentModelList docs) {
        for (DocumentModel docMod : docs) {
            try {
                ToutaticeBulkDocumentCopiedListener.throwEvent(docCtx, "documentCreatedByCopy", session, docMod);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            if (!docMod.isFolder()) continue;
            DocumentModelList children = null;
            try {
                children = session.query(String.format("SELECT * FROM Document WHERE ecm:parentId = '%s' AND ecm:isVersion = 0 AND ecm:currentLifeCycleState <> 'deleted' ", docMod.getRef()));
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            if (children == null) continue;
            this.fireCreatedByCopy(docCtx, session, event, children);
        }
    }

    public static void throwEvent(DocumentEventContext docCtx, String eventName, CoreSession session, DocumentModel docMod) {
        DocumentEventContext newDocCtx = new DocumentEventContext(session, docCtx.getPrincipal(), docMod);
        EventImpl eventToThrow = new EventImpl(eventName, (EventContext)newDocCtx);
        newDocCtx.setProperty(BLOCK, (Serializable)Boolean.valueOf(true));
        ToutaticeBulkDocumentCopiedListener.getEventService().fireEvent((Event)eventToThrow);
        ToutaticeDocumentHelper.saveDocumentSilently(session, docMod, true);
    }
}

