/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.persistence;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveReader;
import org.nuxeo.ecm.core.lifecycle.LifeCycle;
import org.nuxeo.ecm.core.lifecycle.LifeCycleService;

public class ToutaticeNuxeoArchiveReader
extends NuxeoArchiveReader {
    private static final Log log = LogFactory.getLog(ToutaticeNuxeoArchiveReader.class);
    private LifeCycleService LCService;
    private Map<String, String> defaultInitialLifeCycleState = new HashMap<String, String>();

    public ToutaticeNuxeoArchiveReader(File file) throws IOException {
        super(file);
    }

    public ExportedDocument read() throws IOException {
        ExportedDocument expDoc = super.read();
        try {
            Document doc;
            Element system;
            if (null != expDoc && null != (system = (doc = expDoc.getDocument()).getRootElement().element("system"))) {
                String initialLifeCycleState = this.getDefaultLifeCycleStateForDoc(doc);
                DefaultElement lcpolicy = (DefaultElement)system.element("lifecycle-policy");
                DefaultElement lcs = (DefaultElement)system.element("lifecycle-state");
                if (null != lcs && "deleted".equals(lcs.getTextTrim())) {
                    expDoc = this.read();
                }
                Iterator itr = system.elementIterator("facet");
                while (null != itr && itr.hasNext()) {
                    DefaultElement facet = (DefaultElement)itr.next();
                    String value = facet.getTextTrim();
                    if (!"Immutable".equals(value)) continue;
                    expDoc = this.read();
                    break;
                }
                if (null != initialLifeCycleState && null != lcpolicy && !"documentRouteElement".equals(lcpolicy.getTextTrim())) {
                    lcs.setText(initialLifeCycleState);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)("Failed to filter document list while import" + (StringUtils.isNotBlank((String)expDoc.getId()) ? " (" + expDoc.getId() + ")" : "") + ", error: " + e.getMessage()));
        }
        return expDoc;
    }

    private String getDefaultLifeCycleStateForDoc(Document doc) {
        String defaultState = null;
        DefaultElement type = (DefaultElement)doc.getRootElement().element("system").element("type");
        if (null != type) {
            if (!this.defaultInitialLifeCycleState.containsKey(type.getTextTrim()) && null != this.getLFService()) {
                String lcName = this.getLFService().getLifeCycleNameFor(type.getTextTrim());
                LifeCycle lc = this.getLFService().getLifeCycleByName(lcName);
                this.defaultInitialLifeCycleState.put(type.getTextTrim(), lc.getDefaultInitialStateName());
            }
            defaultState = this.defaultInitialLifeCycleState.get(type.getTextTrim());
        }
        return defaultState;
    }

    private LifeCycleService getLFService() {
        if (null == this.LCService) {
            this.LCService = NXCore.getLifeCycleService();
        }
        return this.LCService;
    }
}

