/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.mime;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.mime.EMimeContentType;
import com.phloc.commons.mime.IMimeType;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class MimeType
implements IMimeType {
    private static final Logger s_aLogger = LoggerFactory.getLogger(MimeType.class);
    private final EMimeContentType m_eContentType;
    private final String m_sContentSubType;
    private final String m_sAsString;

    public MimeType(@Nonnull EMimeContentType eMimeContentType, @Nonnull @Nonempty String string) {
        if (eMimeContentType == null) {
            throw new NullPointerException("contentType");
        }
        if (StringHelper.hasNoText(string)) {
            throw new IllegalArgumentException("contentSubType may not be empty");
        }
        this.m_eContentType = eMimeContentType;
        this.m_sContentSubType = string;
        this.m_sAsString = this.m_eContentType.getText() + '/' + this.m_sContentSubType;
    }

    @Override
    @Nonnull
    public EMimeContentType getContentType() {
        return this.m_eContentType;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getContentSubType() {
        return this.m_sContentSubType;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsString() {
        return this.m_sAsString;
    }

    @Override
    @Nonnull
    public String getAsStringWithEncoding(String string) {
        return this.m_sAsString + "; charset=" + string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MimeType)) {
            return false;
        }
        MimeType mimeType = (MimeType)object;
        return this.m_eContentType.equals(mimeType.m_eContentType) && this.m_sContentSubType.equals(mimeType.m_sContentSubType);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eContentType)).append(this.m_sContentSubType).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("contentType", this.m_eContentType).append("subType", this.m_sContentSubType).toString();
    }

    @Nullable
    public static IMimeType parseFromStringWithoutEncoding(@Nullable String string) {
        String string2;
        EMimeContentType eMimeContentType;
        int n;
        if (StringHelper.hasText(string) && (n = string.indexOf(47)) != -1 && (eMimeContentType = EMimeContentType.getFromIDOrNull(string2 = string.substring(0, n))) != null) {
            String string3 = string.substring(n + 1);
            return new MimeType(eMimeContentType, string3);
        }
        return null;
    }
}

