/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.mutable;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.mutable.IMutableNumeric;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class MutableFloat
extends Number
implements IMutableNumeric<MutableFloat> {
    public static final float DEFAULT_VALUE = 0.0f;
    private float m_fValue;

    public MutableFloat() {
        this(0.0f);
    }

    public MutableFloat(@Nonnull Float f) {
        this(f.floatValue());
    }

    public MutableFloat(float f) {
        this.m_fValue = f;
    }

    @Override
    public float floatValue() {
        return this.m_fValue;
    }

    @Nonnull
    public Float getAsFloat() {
        return Float.valueOf(this.m_fValue);
    }

    @Override
    public double doubleValue() {
        return this.m_fValue;
    }

    @Override
    public int intValue() {
        return (int)this.m_fValue;
    }

    @Override
    public long longValue() {
        return (long)this.m_fValue;
    }

    public float inc() {
        return this.inc(1.0f);
    }

    public float inc(float f) {
        this.m_fValue += f;
        return this.m_fValue;
    }

    public float dec() {
        return this.inc(-1.0f);
    }

    public float dec(float f) {
        return this.inc(-f);
    }

    @Nonnull
    public EChange set(float f) {
        if (EqualsUtils.equals(f, this.m_fValue)) {
            return EChange.UNCHANGED;
        }
        this.m_fValue = f;
        return EChange.CHANGED;
    }

    @Override
    public boolean is0() {
        return EqualsUtils.equals(this.m_fValue, 0.0f);
    }

    @Override
    public boolean isNot0() {
        return !this.is0();
    }

    @Override
    public boolean isSmaller0() {
        return Double.compare(this.m_fValue, 0.0) < 0;
    }

    @Override
    public boolean isSmallerOrEqual0() {
        return Double.compare(this.m_fValue, 0.0) <= 0;
    }

    @Override
    public boolean isGreater0() {
        return Double.compare(this.m_fValue, 0.0) > 0;
    }

    @Override
    public boolean isGreaterOrEqual0() {
        return Double.compare(this.m_fValue, 0.0) >= 0;
    }

    @Override
    public int compareTo(MutableFloat mutableFloat) {
        return Double.compare(this.m_fValue, mutableFloat.m_fValue);
    }

    @Override
    @Nonnull
    public MutableFloat getClone() {
        return new MutableFloat(this.m_fValue);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MutableFloat)) {
            return false;
        }
        MutableFloat mutableFloat = (MutableFloat)object;
        return EqualsUtils.equals(this.m_fValue, mutableFloat.m_fValue);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_fValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_fValue).toString();
    }
}

