/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.text.resource;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.text.resource.ResourceBundleUtils;
import java.io.Serializable;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PropertyKey;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ResourceBundleKey
implements Serializable {
    private final String m_sBundleName;
    private final String m_sKey;

    public ResourceBundleKey(@Nonnull @Nonempty String string, @Nonnull @PropertyKey @Nonempty String string2) {
        if (StringHelper.hasNoText(string)) {
            throw new IllegalArgumentException("bundleName");
        }
        if (StringHelper.hasNoText(string2)) {
            throw new IllegalArgumentException("key");
        }
        this.m_sBundleName = string;
        this.m_sKey = string2;
    }

    @Nonnull
    @Nonempty
    public String getBundleName() {
        return this.m_sBundleName;
    }

    @Nonnull
    @PropertyKey
    @Nonempty
    public String getKey() {
        return this.m_sKey;
    }

    @Nullable
    public String getString(@Nonnull Locale locale) {
        return ResourceBundleUtils.getString(this.m_sBundleName, locale, this.m_sKey);
    }

    @Nullable
    public String getString(@Nonnull Locale locale, @Nonnull ClassLoader classLoader) {
        return ResourceBundleUtils.getString(this.m_sBundleName, locale, this.m_sKey, classLoader);
    }

    @Nullable
    public String getUtf8String(@Nonnull Locale locale) {
        return ResourceBundleUtils.getUtf8String(this.m_sBundleName, locale, this.m_sKey);
    }

    @Nullable
    public String getUtf8String(@Nonnull Locale locale, @Nonnull ClassLoader classLoader) {
        return ResourceBundleUtils.getUtf8String(this.m_sBundleName, locale, this.m_sKey, classLoader);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ResourceBundleKey)) {
            return false;
        }
        ResourceBundleKey resourceBundleKey = (ResourceBundleKey)object;
        return this.m_sBundleName.equals(resourceBundleKey.m_sBundleName) && this.m_sKey.equals(resourceBundleKey.m_sKey);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sBundleName).append(this.m_sKey).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("bundleName", this.m_sBundleName).append("key", this.m_sKey).toString();
    }
}

