/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.handlers.fprpc;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.Cookie;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.wss.WSSException;
import org.nuxeo.wss.fprpc.FPRPCCall;
import org.nuxeo.wss.fprpc.FPRPCRequest;
import org.nuxeo.wss.fprpc.FPRPCResponse;
import org.nuxeo.wss.handlers.fprpc.AbstractFPRPCHandler;
import org.nuxeo.wss.handlers.fprpc.FPRPCHandler;
import org.nuxeo.wss.spi.WSSBackend;
import org.nuxeo.wss.spi.WSSListItem;
import org.nuxeo.wss.url.WSSUrlMapper;

public class OWSSvrHandler
extends AbstractFPRPCHandler
implements FPRPCHandler {
    private static final Log log = LogFactory.getLog(OWSSvrHandler.class);

    @Override
    protected void processCall(FPRPCRequest request, FPRPCResponse fpResponse, int callIndex, WSSBackend backend) throws WSSException {
        FPRPCCall call = request.getCalls().get(callIndex);
        fpResponse.addRenderingParameter("siteRoot", request.getSitePath());
        fpResponse.addRenderingParameter("request", request);
        log.debug((Object)("Handling FP OWS call on method " + call.getMethodName()));
        if ("FileOpen".equals(call.getMethodName())) {
            this.handleFileDialog(request, fpResponse, call, backend, false);
        } else {
            if ("FileSave".equals(call.getMethodName())) {
                try {
                    fpResponse.getHttpResponse().sendError(406, "Please use list-document API for save as");
                    return;
                }
                catch (IOException e) {
                    throw new WSSException("Error while sending error!", e);
                }
            }
            if ("SaveForm".equals(call.getMethodName())) {
                if ("HEAD".equals(request.getHttpRequest().getMethod())) {
                    fpResponse.setContentType("text/html");
                    fpResponse.getHttpResponse().setStatus(410);
                    return;
                }
                fpResponse.setContentType("text/html");
                fpResponse.getHttpResponse().setStatus(404);
                return;
            }
        }
    }

    protected void handleFileDialog(FPRPCRequest request, FPRPCResponse response, FPRPCCall call, WSSBackend backend, boolean save) throws WSSException {
        if ("HEAD".equals(request.getHttpRequest().getMethod())) {
            response.setContentType("text/html");
            return;
        }
        String location = call.getParameters().get("location");
        location = WSSUrlMapper.getUrlWithSitePath(request, location);
        WSSListItem parent = backend.getItem(location);
        List<WSSListItem> items = backend.listItems(location);
        response.addRenderingParameter("parent", parent);
        response.addRenderingParameter("items", items);
        response.setContentType("text/html");
        Cookie MSOWebPartCookie = new Cookie("MSOWebPartPage_AnonymousAccessCookie", "80");
        MSOWebPartCookie.setPath("/");
        MSOWebPartCookie.setMaxAge(3600);
        response.getHttpResponse().setCharacterEncoding("UTF-8");
        response.getHttpResponse().addCookie(MSOWebPartCookie);
        if (save) {
            response.setRenderingTemplateName("FileOpen.ftl");
        } else {
            response.setRenderingTemplateName("FileOpen.ftl");
        }
    }
}

