/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.listener;

import fr.toutatice.ecm.platform.core.helper.ToutaticeOperationHelper;
import fr.toutatice.ecm.platform.core.utils.exception.ToutaticeException;
import org.apache.commons.lang.ArrayUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class ToutaticeAsynchronousUpdateListener
implements PostCommitEventListener {
    private static final String MOVE_OP_CHAIN = "moveOp";
    private static final String[] SELECTED_EVENTS = new String[]{"documentCreated", "documentCreatedByCopy", "documentMoved", "documentRestored"};

    public void handleEvent(EventBundle events) throws ClientException {
        for (Event event : events) {
            if (!(event.getContext() instanceof DocumentEventContext)) continue;
            EventContext ctx = event.getContext();
            DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
            DocumentModel document = docCtx.getSourceDocument();
            CoreSession session = ctx.getCoreSession();
            if (document.isImmutable()) {
                return;
            }
            try {
                if (!ArrayUtils.contains((Object[])SELECTED_EVENTS, (Object)event.getName())) continue;
                ToutaticeOperationHelper.runOperationChain(session, MOVE_OP_CHAIN, document);
            }
            catch (ToutaticeException e) {
                throw new ClientException((Throwable)e);
            }
        }
    }
}

