/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.persistence;

import fr.toutatice.ecm.platform.core.persistence.ToutaticeDocumentModelWriter;
import fr.toutatice.ecm.platform.core.persistence.ToutaticeNuxeoArchiveReader;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveReader;
import org.nuxeo.ecm.platform.filemanager.service.extension.ExportedZipImporter;
import org.nuxeo.ecm.platform.types.TypeManager;

public class ToutaticeExportedZipImporter
extends ExportedZipImporter {
    private static final long serialVersionUID = -3660849547853979447L;
    private static final Log log = LogFactory.getLog(ToutaticeExportedZipImporter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModel create(CoreSession documentManager, Blob content, String path, boolean overwrite, String filename, TypeManager typeService) throws ClientException, IOException {
        IdRef resultingRef;
        DocumentModel target;
        File tmp = File.createTempFile("xml-importer", null);
        content.transferTo(tmp);
        ZipFile zip = ToutaticeExportedZipImporter.getArchiveFileIfValid((File)tmp);
        if (zip == null) {
            tmp.delete();
            return null;
        }
        boolean importWithIds = false;
        ToutaticeNuxeoArchiveReader reader = new ToutaticeNuxeoArchiveReader(tmp);
        ExportedDocument root = reader.read();
        IdRef rootRef = new IdRef(root.getId());
        if (documentManager.exists((DocumentRef)rootRef) && (target = documentManager.getDocument((DocumentRef)rootRef)).getPath().removeLastSegments(1).equals((Object)new Path(path))) {
            importWithIds = true;
        }
        ToutaticeDocumentModelWriter writer = new ToutaticeDocumentModelWriter(documentManager, path, 10);
        reader.close();
        reader = new NuxeoArchiveReader(tmp);
        if (overwrite && importWithIds) {
            resultingRef = rootRef;
        } else {
            String rootName = root.getPath().lastSegment();
            resultingRef = new PathRef(path, rootName);
        }
        try {
            DocumentPipeImpl pipe = new DocumentPipeImpl(10);
            pipe.setReader((DocumentReader)reader);
            pipe.setWriter((DocumentWriter)writer);
            pipe.run();
        }
        catch (Exception e) {
            log.warn((Object)e, (Throwable)e);
        }
        finally {
            reader.close();
            writer.close();
        }
        tmp.delete();
        return documentManager.getDocument((DocumentRef)resultingRef);
    }
}

