/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.security;

import java.security.Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.security.AbstractSecurityPolicy;

public class MasterOwnerSecurityPolicy
extends AbstractSecurityPolicy {
    private static final Log log = LogFactory.getLog(MasterOwnerSecurityPolicy.class);

    public Access checkPermission(Document doc, ACP mergedAcp, Principal principal, String permission, String[] resolvedPermissions, String[] additionalPrincipals) {
        long begin = System.currentTimeMillis();
        Access access = null;
        if (mergedAcp == null) {
            access = Access.UNKNOWN;
        } else {
            access = mergedAcp.getAccess(additionalPrincipals, new String[]{"MasterOwner"});
            if (!Access.GRANT.equals(access)) {
                access = Access.UNKNOWN;
            }
        }
        if (log.isTraceEnabled()) {
            long end = System.currentTimeMillis();
            log.trace((Object)(": " + String.valueOf(end - begin) + " ms"));
        }
        return access;
    }

    public boolean isRestrictingPermission(String permission) {
        assert (permission.equals("Browse"));
        return false;
    }

    public boolean isExpressibleInQuery() {
        return true;
    }

    public SQLQuery.Transformer getQueryTransformer() {
        return SQLQuery.Transformer.IDENTITY;
    }
}

