/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JVMVersion
implements Comparable<JVMVersion> {
    public final int major;
    public final int update;
    static final Pattern PreJDK9Pattern = Pattern.compile("1.(\\d).\\d(?:_(\\d+))?(?:-.*)?");

    public JVMVersion(int major, int minor) {
        this.major = major;
        this.update = minor;
    }

    public int compareTo(JVMVersion o, UpTo upTo) {
        if (this.major != o.major) {
            return this.major - o.major;
        }
        if (upTo == UpTo.MAJOR) {
            return 0;
        }
        if (this.update != o.update) {
            return this.update - o.update;
        }
        return 0;
    }

    @Override
    public int compareTo(JVMVersion o) {
        return this.compareTo(o, UpTo.UPDATE);
    }

    public String toString() {
        return String.format("%d.%d", this.major, this.update);
    }

    public static JVMVersion parse(String version) throws ParseException {
        if (version.startsWith("1.")) {
            return JVMVersion.parsePreJdk9(version);
        }
        throw new ParseException("Unknown JVM version format", -1);
    }

    public static JVMVersion parsePreJdk9(String version) throws ParseException {
        Matcher matcher = PreJDK9Pattern.matcher(version);
        if (!matcher.matches()) {
            throw new ParseException("Cannot parse " + version + " as a pre jdk9 jvm version", -1);
        }
        int groupCount = matcher.groupCount();
        String major = matcher.group(1);
        String minor = groupCount >= 2 ? matcher.group(2) : null;
        return new JVMVersion(Integer.parseInt(major), minor == null ? 0 : Integer.parseInt(minor));
    }

    public static enum UpTo {
        MAJOR,
        UPDATE;

    }
}

