/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.plarform.web.filemanager;

import java.io.Serializable;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang.ArrayUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileInfo;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

@Name(value="ottcFileValidator")
@Scope(value=ScopeType.SESSION)
@Install(precedence=31)
public class FileValidatorBean
implements Serializable {
    private static final long serialVersionUID = 6142695676085523525L;
    public static final String[] MEDIA_PRIMARY_MIME_TYPES = new String[]{"image", "audio", "video"};

    public void validateMimeType(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (value != null) {
            InputFileInfo file = (InputFileInfo)value;
            try {
                MimeType mimeType = new MimeType((String)file.getMimeType());
                if (ArrayUtils.contains((Object[])MEDIA_PRIMARY_MIME_TYPES, (Object)mimeType.getPrimaryType())) {
                    String msg = ComponentUtils.translate((FacesContext)context, (String)"ottc.validator.file.bad.mime.type");
                    FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null);
                    throw new ValidatorException(message);
                }
            }
            catch (MimeTypeParseException e) {
                String msg = ComponentUtils.translate((FacesContext)context, (String)"ottc.validator.file.unknown.mime.type");
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null);
                throw new ValidatorException(message);
            }
        }
    }
}

