/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.routing.core.api.DocumentRoutingEscalationService;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.runtime.api.Framework;

public class DocumentRoutingEscalationServiceImpl
implements DocumentRoutingEscalationService {
    private static Log log = LogFactory.getLog(DocumentRoutingEscalationServiceImpl.class);
    public static final String queryForSuspendedNodesWithEscalation = "Select DISTINCT ecm:uuid from RouteNode WHERE ecm:currentLifeCycleState = 'suspended' AND ( rnode:escalationRules/*1/executed = 0 OR rnode:escalationRules/*1/multipleExecution = 1 )";

    @Override
    public List<String> queryForSuspendedNodesWithEscalation(CoreSession session) throws ClientException {
        final ArrayList<String> nodesDocIds = new ArrayList<String>();
        new UnrestrictedSessionRunner(session){

            public void run() throws ClientException {
                IterableQueryResult results = this.session.queryAndFetch(DocumentRoutingEscalationServiceImpl.queryForSuspendedNodesWithEscalation, "NXQL", new Object[0]);
                for (Map result : results) {
                    nodesDocIds.add(((Serializable)result.get("ecm:uuid")).toString());
                    log.trace((Object)("Inspecting node for escalation rules:" + ((Serializable)result.get("ecm:uuid")).toString()));
                }
                results.close();
            }
        }.runUnrestricted();
        return nodesDocIds;
    }

    @Override
    public List<GraphNode.EscalationRule> computeEscalationRulesToExecute(GraphNode node) throws ClientException {
        return node.evaluateEscalationRules();
    }

    @Override
    public void scheduleExecution(GraphNode.EscalationRule rule, CoreSession session) {
        WorkManager manager = (WorkManager)Framework.getLocalService(WorkManager.class);
        manager.schedule((Work)new EscalationRuleWork(rule.getId(), rule.getNode().getDocument().getId(), session.getRepositoryName()), WorkManager.Scheduling.IF_NOT_SCHEDULED);
    }

    private static void markRuleAsExecuted(String nodeDocId, String escalationRuleId, CoreSession session) throws ClientException {
        DocumentModel nodeDoc = session.getDocument((DocumentRef)new IdRef(nodeDocId));
        GraphNode node = (GraphNode)nodeDoc.getAdapter(GraphNode.class);
        List<GraphNode.EscalationRule> rules = node.getEscalationRules();
        GraphNode.EscalationRule rule = null;
        for (GraphNode.EscalationRule escalationRule : rules) {
            if (!escalationRuleId.equals(escalationRule.getId())) continue;
            rule = escalationRule;
            break;
        }
        rule.setExecuted(true);
        session.saveDocument(nodeDoc);
    }

    public static class EscalationRuleWork
    extends AbstractWork {
        private static final long serialVersionUID = 1L;
        protected String escalationRuleId;
        protected String nodeDocId;
        public static final String CATEGORY = "routingEscalation";

        public EscalationRuleWork(String escalationRuleId, String nodeDocId, String repositoryName) {
            super(repositoryName + ":" + nodeDocId + ":escalationRule:" + escalationRuleId);
            this.repositoryName = repositoryName;
            this.escalationRuleId = escalationRuleId;
            this.nodeDocId = nodeDocId;
        }

        public String getTitle() {
            return this.getId();
        }

        public String getCategory() {
            return CATEGORY;
        }

        public void work() throws Exception {
            this.initSession();
            DocumentModel nodeDoc = this.session.getDocument((DocumentRef)new IdRef(this.nodeDocId));
            GraphNode node = (GraphNode)nodeDoc.getAdapter(GraphNode.class);
            if (node == null) {
                throw new ClientException("Can't execute worker '" + this.getId() + "' : the document '" + this.nodeDocId + "' can not be adapted to a GraphNode");
            }
            List<GraphNode.EscalationRule> rules = node.getEscalationRules();
            GraphNode.EscalationRule rule = null;
            for (GraphNode.EscalationRule escalationRule : rules) {
                if (!this.escalationRuleId.equals(escalationRule.getId())) continue;
                rule = escalationRule;
                break;
            }
            if (rule == null) {
                throw new ClientException("Can't execute worker '" + this.getId() + "' : the rule '" + this.escalationRuleId + "' was not found on the node '" + this.nodeDocId + "'");
            }
            OperationContext context = new OperationContext(this.session);
            context.putAll(node.getWorkflowContextualInfo(this.session, true));
            context.setInput(context.get((Object)"documents"));
            try {
                boolean alreadyExecuted = this.getExecutionStatus(rule, this.session);
                if (alreadyExecuted && !rule.isMultipleExecution()) {
                    log.trace((Object)("Rule " + rule.getId() + "on node " + node.getId() + " already executed"));
                    return;
                }
                node.executeChain(rule.getChain());
                DocumentRoutingEscalationServiceImpl.markRuleAsExecuted(this.nodeDocId, this.escalationRuleId, this.session);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ClientException("Error when executing worker: " + this.getTitle(), (Throwable)e);
            }
        }

        public boolean getExecutionStatus(GraphNode.EscalationRule rule, CoreSession session) throws ClientException {
            DocumentModel nodeDoc = session.getDocument((DocumentRef)new IdRef(rule.getNode().getDocument().getId()));
            GraphNode node = (GraphNode)nodeDoc.getAdapter(GraphNode.class);
            List<GraphNode.EscalationRule> rules = node.getEscalationRules();
            for (GraphNode.EscalationRule escalationRule : rules) {
                if (rule.compareTo(escalationRule) != 0) continue;
                return escalationRule.isExecuted();
            }
            return false;
        }
    }
}

