/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.list;

import com.phloc.commons.IHasSize;
import com.phloc.commons.annotations.MustImplementEqualsAndHashcode;
import com.phloc.commons.factory.FactoryNull;
import com.phloc.commons.factory.IFactory;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Vector;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class SafeVector<ELEMENTTYPE>
extends Vector<ELEMENTTYPE>
implements IHasSize {
    @MustImplementEqualsAndHashcode
    private final IFactory<ELEMENTTYPE> m_aFactory;

    public SafeVector() {
        this(FactoryNull.getInstance());
    }

    public SafeVector(@Nonnull IFactory<ELEMENTTYPE> iFactory) {
        if (iFactory == null) {
            throw new NullPointerException("If you use the constructor with an IFactory you have to provide anything other than null.");
        }
        this.m_aFactory = iFactory;
    }

    private void _ensureSize(@Nonnegative int n) {
        while (this.size() <= n) {
            this.add(this.m_aFactory.create());
        }
    }

    @Override
    public synchronized ELEMENTTYPE get(@Nonnegative int n) {
        this._ensureSize(n);
        return (ELEMENTTYPE)super.get(n);
    }

    @Override
    public synchronized ELEMENTTYPE set(@Nonnegative int n, @Nonnull ELEMENTTYPE ELEMENTTYPE) {
        this._ensureSize(n);
        return super.set(n, ELEMENTTYPE);
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        SafeVector safeVector = (SafeVector)object;
        return this.m_aFactory.equals(safeVector.m_aFactory);
    }

    @Override
    public synchronized int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aFactory).getHashCode();
    }

    @Override
    public synchronized String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("factory", this.m_aFactory).toString();
    }
}

