/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.Archive;
import org.jrobin.core.RrdAllocator;
import org.jrobin.core.RrdBackend;
import org.jrobin.core.RrdDoubleArray;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdInt;
import org.jrobin.core.RrdUpdater;
import org.jrobin.core.Util;

public class Robin
implements RrdUpdater {
    private Archive parentArc;
    private RrdInt pointer;
    private RrdDoubleArray values;
    private int rows;

    Robin(Archive parentArc, int rows, boolean shouldInitialize) throws IOException {
        this.parentArc = parentArc;
        this.pointer = new RrdInt(this);
        this.values = new RrdDoubleArray(this, rows);
        this.rows = rows;
        if (shouldInitialize) {
            this.pointer.set(0);
            this.values.set(0, Double.NaN, rows);
        }
    }

    public double[] getValues() throws IOException {
        return this.getValues(0, this.rows);
    }

    void store(double newValue) throws IOException {
        int position = this.pointer.get();
        this.values.set(position, newValue);
        this.pointer.set((position + 1) % this.rows);
    }

    void bulkStore(double newValue, int bulkCount) throws IOException {
        assert (bulkCount <= this.rows) : "Invalid number of bulk updates: " + bulkCount + " rows=" + this.rows;
        int position = this.pointer.get();
        int tailUpdateCount = Math.min(this.rows - position, bulkCount);
        this.values.set(position, newValue, tailUpdateCount);
        this.pointer.set((position + tailUpdateCount) % this.rows);
        int headUpdateCount = bulkCount - tailUpdateCount;
        if (headUpdateCount > 0) {
            this.values.set(0, newValue, headUpdateCount);
            this.pointer.set(headUpdateCount);
        }
    }

    void update(double[] newValues) throws IOException {
        assert (this.rows == newValues.length) : "Invalid number of robin values supplied (" + newValues.length + "), exactly " + this.rows + " needed";
        this.pointer.set(0);
        this.values.writeDouble(0, newValues);
    }

    public void setValues(double[] newValues) throws IOException, RrdException {
        if (this.rows != newValues.length) {
            throw new RrdException("Invalid number of robin values supplied (" + newValues.length + "), exactly " + this.rows + " needed");
        }
        this.update(newValues);
    }

    public void setValues(double newValue) throws IOException {
        double[] values = new double[this.rows];
        int i = 0;
        while (i < values.length) {
            values[i] = newValue;
            ++i;
        }
        this.update(values);
    }

    String dump() throws IOException {
        double[] values;
        StringBuffer buffer = new StringBuffer("Robin " + this.pointer.get() + "/" + this.rows + ": ");
        double[] dArray = values = this.getValues();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            buffer.append(Util.formatDouble(value, true)).append(" ");
            ++n2;
        }
        buffer.append("\n");
        return buffer.toString();
    }

    public double getValue(int index) throws IOException {
        int arrayIndex = (this.pointer.get() + index) % this.rows;
        return this.values.get(arrayIndex);
    }

    public void setValue(int index, double value) throws IOException {
        int arrayIndex = (this.pointer.get() + index) % this.rows;
        this.values.set(arrayIndex, value);
    }

    double[] getValues(int index, int count) throws IOException {
        assert (count <= this.rows) : "Too many values requested: " + count + " rows=" + this.rows;
        int startIndex = (this.pointer.get() + index) % this.rows;
        int tailReadCount = Math.min(this.rows - startIndex, count);
        double[] tailValues = this.values.get(startIndex, tailReadCount);
        if (tailReadCount < count) {
            int headReadCount = count - tailReadCount;
            double[] headValues = this.values.get(0, headReadCount);
            double[] values = new double[count];
            int k = 0;
            double[] dArray = tailValues;
            int n = tailValues.length;
            int n2 = 0;
            while (n2 < n) {
                double tailValue = dArray[n2];
                values[k++] = tailValue;
                ++n2;
            }
            dArray = headValues;
            n = headValues.length;
            n2 = 0;
            while (n2 < n) {
                double headValue = dArray[n2];
                values[k++] = headValue;
                ++n2;
            }
            return values;
        }
        return tailValues;
    }

    public Archive getParent() {
        return this.parentArc;
    }

    public int getSize() {
        return this.rows;
    }

    public void copyStateTo(RrdUpdater other) throws IOException, RrdException {
        if (!(other instanceof Robin)) {
            throw new RrdException("Cannot copy Robin object to " + other.getClass().getName());
        }
        Robin robin = (Robin)other;
        int rowsDiff = this.rows - robin.rows;
        if (rowsDiff == 0) {
            robin.pointer.set(this.pointer.get());
            robin.values.writeBytes(this.values.readBytes());
        } else {
            int i = 0;
            while (i < robin.rows) {
                int j = i + rowsDiff;
                robin.store(j >= 0 ? this.getValue(j) : Double.NaN);
                ++i;
            }
        }
    }

    public void filterValues(double minValue, double maxValue) throws IOException {
        int i = 0;
        while (i < this.rows) {
            double value = this.values.get(i);
            if (!Double.isNaN(minValue) && !Double.isNaN(value) && minValue > value) {
                this.values.set(i, Double.NaN);
            }
            if (!Double.isNaN(maxValue) && !Double.isNaN(value) && maxValue < value) {
                this.values.set(i, Double.NaN);
            }
            ++i;
        }
    }

    public RrdBackend getRrdBackend() {
        return this.parentArc.getRrdBackend();
    }

    public RrdAllocator getRrdAllocator() {
        return this.parentArc.getRrdAllocator();
    }
}

