/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.url;

import fr.toutatice.ecm.platform.service.url.ToutaticeDocumentLocation;
import fr.toutatice.ecm.platform.service.url.WebIdCodec;
import fr.toutatice.ecm.platform.service.url.WebIdRef;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;

public class WebIdFileCodec
extends WebIdCodec {
    public static final String WEBID_FILE_PREFIX = "webpicsfile/";

    @Override
    public String getPrefix() {
        if (this.prefix != null) {
            return this.prefix;
        }
        return WEBID_FILE_PREFIX;
    }

    @Override
    public DocumentView getDocumentViewFromUrl(String url) {
        DocumentView webView = super.getDocumentViewFromUrl(url.replace(WEBID_FILE_PREFIX, "web/"));
        if (webView != null) {
            ToutaticeDocumentLocation docLoc = (ToutaticeDocumentLocation)webView.getDocumentLocation();
            WebIdRef webIdRef = docLoc.getWebIdRef();
            String webid = (String)webIdRef.reference();
            Map webviewParameters = webView.getParameters();
            HashMap<String, String> parameters = new HashMap<String, String>();
            String content = (String)webviewParameters.get("content");
            if (content != null) {
                parameters.put("FILE_PROPERTY_PATH", content.concat(":content"));
            } else {
                parameters.put("FILE_PROPERTY_PATH", "Original:content");
            }
            parameters.put("FILENAME", webid);
            parameters.putAll(webviewParameters);
            return new DocumentViewImpl((DocumentLocation)docLoc, null, parameters);
        }
        return webView;
    }

    @Override
    public String getUrlFromDocumentView(DocumentView docView) {
        String webUrl = super.getUrlFromDocumentView(docView);
        if (webUrl != null) {
            webUrl = webUrl.replace("web/", WEBID_FILE_PREFIX);
        }
        return webUrl;
    }
}

