/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.platform.rendition.Rendition;
import org.nuxeo.ecm.platform.rendition.RenditionException;
import org.nuxeo.ecm.platform.rendition.extension.DefaultAutomationRenditionProvider;
import org.nuxeo.ecm.platform.rendition.extension.RenditionProvider;
import org.nuxeo.ecm.platform.rendition.impl.LiveRendition;
import org.nuxeo.ecm.platform.rendition.impl.StoredRendition;
import org.nuxeo.ecm.platform.rendition.service.RenditionCreator;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.rendition.service.RenditionFinder;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class RenditionServiceImpl
extends DefaultComponent
implements RenditionService {
    public static final String RENDITION_DEFINITIONS_EP = "renditionDefinitions";
    private static final Log log = LogFactory.getLog(RenditionServiceImpl.class);
    protected AutomationService automationService;
    protected Map<String, RenditionDefinition> renditionDefinitions;

    public void activate(ComponentContext context) throws Exception {
        this.renditionDefinitions = new HashMap<String, RenditionDefinition>();
        super.activate(context);
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.renditionDefinitions = null;
        super.deactivate(context);
    }

    public List<RenditionDefinition> getDeclaredRenditionDefinitions() {
        return new ArrayList<RenditionDefinition>(this.renditionDefinitions.values());
    }

    public List<RenditionDefinition> getDeclaredRenditionDefinitionsForProviderType(String providerType) {
        ArrayList<RenditionDefinition> defs = new ArrayList<RenditionDefinition>();
        for (RenditionDefinition def : this.getDeclaredRenditionDefinitions()) {
            if (!def.getProviderType().equals(providerType)) continue;
            defs.add(def);
        }
        return defs;
    }

    public List<RenditionDefinition> getAvailableRenditionDefinitions(DocumentModel doc) {
        ArrayList<RenditionDefinition> defs = new ArrayList<RenditionDefinition>();
        for (RenditionDefinition def : this.renditionDefinitions.values()) {
            if (!def.getProvider().isAvailable(doc, def)) continue;
            defs.add(def);
        }
        return defs;
    }

    public DocumentRef storeRendition(DocumentModel source, String renditionDefinitionName) throws RenditionException {
        Rendition rendition = this.getRendition(source, renditionDefinitionName, true);
        return rendition.getHostDocument().getRef();
    }

    protected DocumentModel storeRendition(DocumentModel sourceDocument, List<Blob> renderedBlobs, String name) throws RenditionException {
        try {
            CoreSession session = sourceDocument.getCoreSession();
            DocumentRef versionRef = this.createVersionIfNeeded(sourceDocument, session);
            DocumentModel version = session.getDocument(versionRef);
            RenditionCreator rc = new RenditionCreator(session, sourceDocument, version, renderedBlobs.get(0), name);
            rc.runUnrestricted();
            DocumentModel detachedRendition = rc.getDetachedDendition();
            detachedRendition.attach(sourceDocument.getSessionId());
            return detachedRendition;
        }
        catch (Exception e) {
            throw new RenditionException("Unable to store rendition", e);
        }
    }

    protected DocumentRef createVersionIfNeeded(DocumentModel source, CoreSession session) throws ClientException {
        DocumentRef versionRef;
        if (source.isVersion()) {
            versionRef = source.getRef();
        } else if (source.isCheckedOut()) {
            versionRef = session.checkIn(source.getRef(), VersioningOption.MINOR, null);
            source.refresh(1, null);
        } else {
            versionRef = session.getLastDocumentVersionRef(source.getRef());
        }
        return versionRef;
    }

    protected AutomationService getAutomationService() throws RenditionException {
        if (this.automationService == null) {
            try {
                this.automationService = (AutomationService)Framework.getService(AutomationService.class);
            }
            catch (Exception e) {
                String errMsg = "Error connecting to AutomationService. " + e.getMessage();
                throw new RenditionException(errMsg, "", e);
            }
            if (this.automationService == null) {
                throw new RenditionException("AutomationService service not bound");
            }
        }
        return this.automationService;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (RENDITION_DEFINITIONS_EP.equals(extensionPoint)) {
            this.registerRendition((RenditionDefinition)contribution);
        }
    }

    protected void registerRendition(RenditionDefinition renditionDefinition) {
        String name = renditionDefinition.getName();
        if (name == null) {
            log.error((Object)"Cannot register rendition without a name");
            return;
        }
        boolean enabled = renditionDefinition.isEnabled();
        if (this.renditionDefinitions.containsKey(name)) {
            log.info((Object)("Overriding rendition with name: " + name));
            if (enabled) {
                renditionDefinition = this.mergeRenditions(this.renditionDefinitions.get(name), renditionDefinition);
            } else {
                log.info((Object)("Disabled rendition with name " + name));
                this.renditionDefinitions.remove(name);
            }
        }
        if (enabled) {
            log.info((Object)("Registering rendition with name: " + name));
            this.renditionDefinitions.put(name, renditionDefinition);
        }
        this.setupProvider(renditionDefinition);
    }

    protected void setupProvider(RenditionDefinition definition) {
        if (definition.getProviderClass() == null) {
            definition.setProvider((RenditionProvider)new DefaultAutomationRenditionProvider());
        } else {
            try {
                RenditionProvider provider = (RenditionProvider)definition.getProviderClass().newInstance();
                definition.setProvider(provider);
            }
            catch (Exception e) {
                log.error((Object)"Unable to create RenditionProvider", (Throwable)e);
            }
        }
    }

    protected RenditionDefinition mergeRenditions(RenditionDefinition oldRenditionDefinition, RenditionDefinition newRenditionDefinition) {
        String operationChain;
        String label = newRenditionDefinition.getLabel();
        if (label != null) {
            oldRenditionDefinition.label = label;
        }
        if ((operationChain = newRenditionDefinition.getOperationChain()) != null) {
            oldRenditionDefinition.operationChain = operationChain;
        }
        return oldRenditionDefinition;
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (RENDITION_DEFINITIONS_EP.equals(extensionPoint)) {
            this.unregisterRendition((RenditionDefinition)contribution);
        }
    }

    protected void unregisterRendition(RenditionDefinition renditionDefinition) {
        String name = renditionDefinition.getName();
        this.renditionDefinitions.remove(name);
        log.info((Object)("Unregistering rendition with name: " + name));
    }

    public Rendition getRendition(DocumentModel doc, String renditionName) throws RenditionException {
        return this.getRendition(doc, renditionName, false);
    }

    public Rendition getRendition(DocumentModel doc, String renditionName, boolean store) throws RenditionException {
        RenditionDefinition renditionDefinition = this.renditionDefinitions.get(renditionName);
        if (renditionDefinition == null) {
            String message = "The rendition definition '%s' is not registered";
            throw new RenditionException(String.format(message, renditionName), "label.rendition.not.defined");
        }
        if (!renditionDefinition.getProvider().isAvailable(doc, renditionDefinition)) {
            throw new RenditionException("Rendition " + renditionName + " not available for this doc " + doc.getId());
        }
        DocumentModel stored = null;
        try {
            if (!doc.isCheckedOut()) {
                RenditionFinder finder = new RenditionFinder(doc, renditionName);
                finder.runUnrestricted();
                stored = finder.getStoredRendition();
                if (stored != null) {
                    stored.attach(doc.getCoreSession().getSessionId());
                }
            }
        }
        catch (ClientException e) {
            throw new RenditionException("Error while searching for stored rendition", (Exception)((Object)e));
        }
        if (stored != null) {
            return new StoredRendition(stored, renditionDefinition);
        }
        LiveRendition rendition = new LiveRendition(doc, renditionDefinition);
        if (store) {
            DocumentModel storedRenditionDoc = this.storeRendition(doc, rendition.getBlobs(), renditionDefinition.getName());
            return new StoredRendition(storedRenditionDoc, renditionDefinition);
        }
        return rendition;
    }

    public List<Rendition> getAvailableRenditions(DocumentModel doc) throws RenditionException {
        ArrayList<Rendition> renditions = new ArrayList<Rendition>();
        if (doc.isProxy()) {
            return renditions;
        }
        List<RenditionDefinition> defs = this.getAvailableRenditionDefinitions(doc);
        if (defs != null) {
            for (RenditionDefinition def : defs) {
                Rendition rendition = this.getRendition(doc, def.getName());
                if (rendition == null) continue;
                renditions.add(rendition);
            }
        }
        return renditions;
    }
}

