package fr.toutatice.cartographie.portail.cartographie.validator;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

import fr.toutatice.cartographie.portail.cartographie.beans.FormAdmin;


@Component("adminValidator")
public class AdminValidator implements Validator {

	protected static final Log logger = LogFactory
			.getLog("fr.toutatice.services");

	public boolean supports(Class<?> klass) {
		return FormAdmin.class.isAssignableFrom(klass);
	}

	public void validate(Object target, Errors errors) {

		FormAdmin form = (FormAdmin) target;

		try {
			if(form.getLatitudeRef()!=null&&!form.getLatitudeRef().trim().isEmpty()){
				double i = Double.parseDouble(form.getLatitudeRef());
			}
		} catch (NumberFormatException nfe) {
			errors.rejectValue("latitudeRef", "double.Invalide");
		}

		try {
			if(form.getLongitudeRef()!=null&&!form.getLongitudeRef().trim().isEmpty()){
				double i = Double.parseDouble(form.getLongitudeRef());
			}
		} catch (NumberFormatException nfe) {
			errors.rejectValue("longitudeRef", "double.Invalide");
		}

		try {
			int i = Integer.parseInt(form.getZoomRef());
		} catch (NumberFormatException nfe) {
			errors.rejectValue("zoomRef", "int.Invalide");
		}
		
		try {
			int i = Integer.parseInt(form.getZoomMax());
		} catch (NumberFormatException nfe) {
			errors.rejectValue("zoomMax", "int.Invalide");
		}
		
		try {
			int i = Integer.parseInt(form.getZoomMin());
		} catch (NumberFormatException nfe) {
			errors.rejectValue("zoomMin", "int.Invalide");
		}

	

	}

}
