/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.cartographie.portail.cartographie;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import javax.annotation.PostConstruct;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.portlet.PortalGenericPortlet;
import org.osivia.portal.api.sequencing.IPortletSequencingService;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

@Controller
@RequestMapping(value={"VIEW"})
public class CartoController
extends PortalGenericPortlet
implements PortletContextAware,
PortletConfigAware {
    protected static final Log logger = LogFactory.getLog((String)"fr.toutatice.services");
    private static final String FLUX_JSON = "fluxGeoJson";
    private static final String URL_tile_layer = System.getProperty("cartoun.map.layer.server.url");
    private PortletContext portletContext;
    private PortletConfig portletConfig;
    private IPortletSequencingService portletSequencingService;

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
        this.portletSequencingService = (IPortletSequencingService)Locator.findMBean(IPortletSequencingService.class, (String)"osivia:service=PortletSequencingService");
    }

    @RenderMapping
    public String accueil(RenderRequest request, PortletSession session, RenderResponse response) throws InterruptedException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String fluxGeoJsonAdmin = window.getProperty("toutatice.cartographie.fluxgeojsonAdmin");
        if (fluxGeoJsonAdmin == null) {
            fluxGeoJsonAdmin = "";
        }
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
        String fluxGeoJson = StringUtils.isNotEmpty((String)fluxGeoJsonAdmin) ? fluxGeoJsonAdmin : (String)this.portletSequencingService.getAttribute(portalControllerContext, FLUX_JSON);
        request.setAttribute(FLUX_JSON, (Object)fluxGeoJson);
        request.setAttribute("cartoun.map.layer.server.url", (Object)URL_tile_layer);
        return "carte";
    }

    @ActionMapping(params={"action=ensavoirplus"})
    public void redirect(@RequestParam String urlRedirect, @RequestParam String zoom, @RequestParam String center, ActionResponse response, ActionRequest request, PortletSession session) throws Exception {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        NuxeoController nuxeoCtl = new NuxeoController((PortletRequest)request, null, this.portletContext);
        if (zoom != null) {
            session.setAttribute("zoom", (Object)zoom);
        }
        if (center != null) {
            session.setAttribute("center", (Object)center);
        }
        String url = nuxeoCtl.getPortalUrlFactory().adaptPortalUrlToNavigation(portalControllerContext, urlRedirect);
        request.setAttribute("osivia.redirection.url", (Object)url);
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }
}

