<%@ page contentType="text/plain; charset=UTF-8"%>
<%@ include file="/WEB-INF/jsp/include.jsp"%>


<portlet:defineObjects />

<portlet:actionURL var="ensavoirplus"><portlet:param name="action" value="ensavoirplus" />
	<portlet:param name="centerLat" value="VAR_CENTERLAT"/>
	<portlet:param name="centerLng" value="VAR_CENTERLNG"/>
	<portlet:param name="zoom" value="VAR_ZOOM"/>
	<portlet:param name="urlRedirect" value="VAR_URL"/>	
</portlet:actionURL>

  <head>
    <meta name="viewport" content="initial-scale=1.0, user-scalable=no" />
  </head>
  
 <body> 
 
  	<input type="hidden" name="cartoHidden" id="cartoHidden" size="1" />
 
    <div id="map-carto"> </div>
 
 	<p><op:translate key="label.credits" /></p>
 	
 	<a id="toTopCarto" class="hidden" href="#listeactivites" onclick="this.className='hidden';">
 		<i class="glyphicons glyphicons-chevron-left rotate90"></i>
	</a>
 
  </body>
  <script type="text/javascript" language="javascript">
     
     	  var map;
     	  
     	   
		     <%
             String fluxGeoJson = (String) request.getAttribute("fluxGeoJson");
             %>
		     
			map = L.map('map-carto');
		     
		     var tileLayer = new L.tileLayer('<%=request.getAttribute("cartoun.map.layer.server.url")%>', {
   				attribution: 'Map data &copy;',
				});
				tileLayer.addTo(map);
		     
		     
		      //Extend the Default marker class
		         var RedIcon = L.Icon.Default.extend({
		            options: {
		            	    iconUrl: 'marker-red.png'
		            }
		         });
		         
		          var BlueIcon = L.Icon.Default.extend({
		            options: {
		            	    iconUrl: 'marker-blue.png'
		            }
		         });
		         
		          var GreenIcon = L.Icon.Default.extend({
		            options: {
		            	    iconUrl: 'marker-green.png'
		            }
		         });
		         
		          var OrangeIcon = L.Icon.Default.extend({
		            options: {
		            	    iconUrl: 'marker-orange.png'
		            }
		         });
		         
		          var YellowIcon = L.Icon.Default.extend({
		            options: {
		            	    iconUrl: 'marker-yellow.png'
		            }
		         });
		         
		         var PurpleIcon = L.Icon.Default.extend({
		            options: {
		            	    iconUrl: 'marker-purple.png'
		            }
		         });
		         
		         function makeGroup(color) {
				    return new L.MarkerClusterGroup({
				    	spiderfyOnMaxZoom: true, 
				    	showCoverageOnHover: true, 
				    	zoomToBoundsOnClick: true,
				        iconCreateFunction: function(cluster) {
				          return new L.DivIcon({
				            iconSize: [20, 20],
				            html: '<div style="text-align:center;color:#fff;background:' +
				            color + '">' + cluster.getChildCount() + '</div>'
				          });
				        }
			      	}).addTo(map);
			    }
			
			<%if (! fluxGeoJson.trim().isEmpty() && !fluxGeoJson.equals("[]")){	%>	
			
			var markers = new L.MarkerClusterGroup({ spiderfyOnMaxZoom: true, showCoverageOnHover: true, zoomToBoundsOnClick: true }); 
			var markersFitBounds = new L.MarkerClusterGroup({ spiderfyOnMaxZoom: true, showCoverageOnHover: true, zoomToBoundsOnClick: true }); 
			
			var clusterred = new L.MarkerClusterGroup({
				        iconCreateFunction: function(cluster) {
				          return new L.DivIcon({
				            iconSize: [20, 20],
				            html: '<div style="text-align:center;color:#fff;background:red">' + cluster.getChildCount() + '</div>'
				          });
				        }
			      	});
			  var clusterblue = new L.MarkerClusterGroup({
				        iconCreateFunction: function(cluster) {
				        	return new L.DivIcon({ html: '<div><span><b>' + cluster.getChildCount() + '</b></span></div>', className: 'marker-cluster-blue', iconSize: new L.Point(30, 30) });
				          
				        }
				       
			    });     	
			
	      	 var clusterorange = new L.MarkerClusterGroup({
				           iconCreateFunction: function(cluster) {
				        	return new L.DivIcon({ html: '<div><span><b>' + cluster.getChildCount() + '</b></span></div>', className: 'marker-cluster-orange', iconSize: new L.Point(30, 30) });
				          
				        }
			      	});
			      	
			 var clustergreen = new L.MarkerClusterGroup({
				        iconCreateFunction: function(cluster) {
				          return new L.DivIcon({
				            iconSize: [20, 20],
				            html: '<div style="text-align:center;color:#fff;background:green">' + cluster.getChildCount() + '</div>'
				          });
				        }
			      	});   
			      	
			      	var clusterpurple = new L.MarkerClusterGroup({
				        iconCreateFunction: function(cluster) {
				          return new L.DivIcon({
				            iconSize: [20, 20],
				            html: '<div style="text-align:center;color:#fff;background:purple">' + cluster.getChildCount() + '</div>'
				          });
				        }
			      	});  
			      	
			      	var clusteryellow = new L.MarkerClusterGroup({
				        iconCreateFunction: function(cluster) {
				          return new L.DivIcon({
				            iconSize: [20, 20],
				            html: '<div style="text-align:center;color:#fff;background:yellow">' + cluster.getChildCount() + '</div>'
				          });
				        }
			      	});      	
				
				var geoJsonLayer = L.geoJson(<%=fluxGeoJson%>, {
				
					pointToLayer: function(feature, latlng) {
                   		return L.marker(latlng, {icon: new BlueIcon()});
            		},
				
					onEachFeature: function (feature, layer) {
						if (feature.properties && feature.properties.popupContent) {
					        layer.bindPopup(feature.properties.popupContent);
					    }
                   		markers.addLayer(layer);
					  
				  		markersFitBounds.addLayer(layer);	
					}
				});
				
				map.addLayer(clusterorange);
				map.addLayer(clusterblue);
				map.addLayer(clusterred);
				map.addLayer(clusteryellow);
				map.addLayer(clustergreen);
				map.addLayer(clusterpurple);
				map.addLayer(markers);
				
				map.on("dragend",function(ev){
					document.getElementById("toTopCarto").className = "visible-xs-block";
		        });
		        
		        <%
		        Integer zoom = (Integer) request.getAttribute("zoom");
		        String centerLat = (String) request.getAttribute("centerLat"); 
		        String centerLng = (String) request.getAttribute("centerLng"); 	
		        if(zoom!=null && centerLat!=null && centerLng!=null){
			        %>
			        var center = new L.LatLng(<%=centerLat%>, <%=centerLng%>);
					map.setView(center,<%=zoom%>);
		            <%
		        }else{
		            %>
				map.fitBounds(markersFitBounds.getBounds(), {padding: [15, 15]});  
					<%
		        }
			}else{%>
				map.fitWorld().zoomIn();
			<%}%>
			
			
			
			function setZoomCenter(aElement){
				var $aElement = $JQry(aElement);
				var redirect = $aElement.attr('href');
				var zoom = map.getZoom();
		  		var center = map.getCenter();

				var urlAction = '${ensavoirplus}'.replace("VAR_CENTERLAT",center.lat).replace("VAR_CENTERLNG",center.lng).replace("VAR_ZOOM",zoom).replace("VAR_URL",redirect);
				location.href = urlAction;
			};
      </script>
