/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.cartoun.plugin.fragment;

import fr.toutatice.cartoun.plugin.util.BapeListCommand;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.PageSelectors;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.fragment.FragmentModule;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class BapeSelectorFragmentModule
extends FragmentModule {
    private static final String LABEL_WINDOW_PROPERTY = "bape.selector.label";
    private static final String SELECTOR_ID_WINDOW_PROPERTY = "bape.selector.id";
    private static final String JSP_NAME = "bape-selector";
    private final DocumentDAO documentDao = DocumentDAO.getInstance();

    public BapeSelectorFragmentModule(PortletContext portletContext) {
        super(portletContext);
    }

    protected void doView(RenderRequest request, RenderResponse response, PortletContext portletContext) throws PortletException, IOException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, portletContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        String domainPath = nuxeoController.getDomainPath();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        request.setAttribute("label", (Object)window.getProperty(LABEL_WINDOW_PROPERTY));
        if (StringUtils.isNotEmpty((String)domainPath)) {
            String selectedId;
            Map selectors;
            List values;
            BapeListCommand command = new BapeListCommand(domainPath);
            Documents documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            ArrayList<DocumentDTO> pools = new ArrayList<DocumentDTO>(documents.size());
            for (Document document : documents) {
                DocumentDTO pool = this.documentDao.toDTO(document);
                pools.add(pool);
            }
            request.setAttribute("pools", pools);
            String selectorId = window.getProperty(SELECTOR_ID_WINDOW_PROPERTY);
            if (selectorId != null && CollectionUtils.isNotEmpty((Collection)(values = (List)(selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"))).get(selectorId))) && (selectedId = (String)values.get(0)) != null) {
                for (DocumentDTO pool : pools) {
                    if (!selectedId.equals(pool.getProperties().get("ttc:webid"))) continue;
                    pool.getProperties().put("selected", true);
                    break;
                }
            }
        }
    }

    protected void doAdmin(RenderRequest request, RenderResponse response, PortletContext portletContext) throws PortletException, IOException {
        new NuxeoController((PortletRequest)request, (PortletResponse)response, portletContext);
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        request.setAttribute("label", (Object)window.getProperty(LABEL_WINDOW_PROPERTY));
        request.setAttribute("selectorId", (Object)window.getProperty(SELECTOR_ID_WINDOW_PROPERTY));
    }

    protected void processAction(ActionRequest request, ActionResponse response, PortletContext portletContext) throws PortletException, IOException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        if (PortletMode.VIEW.equals((Object)request.getPortletMode()) && "filter".equals(request.getParameter("javax.portlet.action"))) {
            String selectorId = window.getProperty(SELECTOR_ID_WINDOW_PROPERTY);
            if (selectorId != null) {
                String selectedId = request.getParameter("selectedId");
                Map selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
                if (StringUtils.isEmpty((String)selectedId)) {
                    selectors.remove(selectorId);
                } else {
                    ArrayList<String> values = new ArrayList<String>(1);
                    values.add(request.getParameter("selectedId"));
                    selectors.put(selectorId, values);
                }
                response.setRenderParameter("selectors", PageSelectors.encodeProperties((Map)selectors));
            }
        } else if ("admin".equals(request.getPortletMode().toString()) && "save".equals(request.getParameter("javax.portlet.action"))) {
            window.setProperty(LABEL_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("label")));
            window.setProperty(SELECTOR_ID_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("selectorId")));
        }
    }

    public boolean isDisplayedInAdmin() {
        return true;
    }

    public String getViewJSPName() {
        return JSP_NAME;
    }

    public String getAdminJSPName() {
        return JSP_NAME;
    }
}

