<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://www.osivia.org/jsp/taglib/osivia-portal" prefix="op" %>

<%@ page isELIgnored="false"%>


<portlet:defineObjects />

<portlet:actionURL name="filter" var="url" />

<c:set var="namespace"><portlet:namespace /></c:set>


<form action="${url}" method="post" role="form">
    <div class="form-group">
        <c:if test="${not empty label}">
            <label for="${namespace}-selector" class="control-label">${label}</label>
        </c:if>
        
        <select id="${namespace}-selector" name="selectedId" onchange="$JQry('#${namespace}-submit').click()" class="form-control">
            <option value=""><op:translate key="ALL" /></option>
            <c:forEach var="pool" items="${pools}">
                <option value="${pool.properties['ttc:webid']}"
                    <c:if test="${pool.properties['selected']}">selected</c:if>
                >${pool.title}</option>
            </c:forEach>
        </select>
    </div>
    
    <div class="form-group hidden-script">
        <button id="${namespace}-submit" type="submit" class="btn btn-default">
            <span><op:translate key="SAVE" /></span>
        </button>
    </div>
</form>
