/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.cartoun.customizer.project;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.security.Principal;
import java.util.Arrays;
import java.util.Map;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.BooleanUtils;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Portal;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.customization.CustomizationModuleMetadatas;
import org.osivia.portal.api.customization.ICustomizationModule;
import org.osivia.portal.api.customization.ICustomizationModulesRepository;
import org.osivia.portal.api.customization.IProjectCustomizationConfiguration;
import org.osivia.portal.api.directory.IDirectoryServiceLocator;
import org.osivia.portal.api.directory.entity.DirectoryPerson;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.urls.IPortalUrlFactory;

public class ProjectCustomizer
extends GenericPortlet
implements ICustomizationModule {
    private static final String CUSTOMIZER_NAME = "cartoun.customizer.project";
    private static final String ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY = "CustomizationModulesRepository";
    private ICustomizationModulesRepository repository;
    private final CustomizationModuleMetadatas metadatas = this.generateMetadatas();
    private final IPortalUrlFactory portalURLFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
    private final IDirectoryServiceLocator directoryServiceLocator = (IDirectoryServiceLocator)Locator.findMBean(IDirectoryServiceLocator.class, (String)"osivia:service=DirectoryServiceLocator");

    private CustomizationModuleMetadatas generateMetadatas() {
        CustomizationModuleMetadatas metadatas = new CustomizationModuleMetadatas();
        metadatas.setName(CUSTOMIZER_NAME);
        metadatas.setModule((ICustomizationModule)this);
        metadatas.setCustomizationIDs(Arrays.asList("osivia.project.customizer.id"));
        return metadatas;
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        this.repository = (ICustomizationModulesRepository)this.getPortletContext().getAttribute(ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY);
        this.repository.register(this.metadatas);
    }

    public void destroy() {
        super.destroy();
        this.repository.unregister(this.metadatas);
    }

    public void customize(String customizationID, CustomizationContext context) {
        Map attributes = context.getAttributes();
        IProjectCustomizationConfiguration configuration = (IProjectCustomizationConfiguration)attributes.get("osivia.project.customizer.configuration");
        if (configuration.isBeforeInvocation() && !configuration.isAdministrator()) {
            Portal portal;
            Page page;
            HttpServletRequest request = configuration.getHttpServletRequest();
            boolean redirect = BooleanUtils.toBoolean((String)request.getParameter("redirect"));
            Principal principal = request.getUserPrincipal();
            if (principal != null && (page = configuration.getPage()).equals((portal = page.getPortal()).getDefaultPage())) {
                PortalControllerContext portalControllerContext = context.getPortalControllerContext();
                HttpServletRequest httpServletRequest = portalControllerContext.getHttpServletRequest();
                String webIdACA = (String)httpServletRequest.getSession().getAttribute("webIdACA");
                if (webIdACA == null) {
                    String uid = httpServletRequest.getUserPrincipal().getName();
                    DirectoryPerson person = this.directoryServiceLocator.getDirectoryService().getPerson(uid);
                    String academy = null;
                    if (person == null) {
                        configuration.setRedirectionURL("/portail/portal/cartoun/loginpage");
                        return;
                    }
                    if (person.getExtraProperties() != null) {
                        academy = (String)person.getExtraProperties().get("codeAcademie");
                    }
                    webIdACA = "sun_" + academy;
                    httpServletRequest.getSession().setAttribute("webIdACA", (Object)webIdACA);
                }
                String sunPath = NuxeoController.webIdToCmsPath((String)webIdACA);
                String url = this.portalURLFactory.getCMSUrl(portalControllerContext, null, sunPath, null, null, null, null, null, null, null);
                configuration.setRedirectionURL(url);
            }
        }
    }
}

