/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.cartoun.plugin;

import fr.toutatice.cartoun.plugin.cms.CartounDomainContextualization;
import fr.toutatice.cartoun.plugin.fragment.BapeSelectorFragmentModule;
import fr.toutatice.cartoun.plugin.fragment.CleanSelectorsFragmentModule;
import fr.toutatice.cartoun.plugin.theming.CartographyTabGroup;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.AbstractPluginPortlet;
import fr.toutatice.portail.cms.nuxeo.api.domain.FragmentType;
import fr.toutatice.portail.cms.nuxeo.api.domain.IMenubarModule;
import fr.toutatice.portail.cms.nuxeo.api.fragment.IFragmentModule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.MenubarContainer;
import org.osivia.portal.api.menubar.MenubarDropdown;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSExtendedDocumentInfos;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;

public class CartounPlugin
extends AbstractPluginPortlet
implements IMenubarModule {
    private static final String PLUGIN_NAME = "cartoun.plugin";
    private IBundleFactory bundleFactory;
    private static final Set<String> itemsToRemove = new HashSet<String>(Arrays.asList("LOCK_URL", "SHARE_BY_EMAIL"));
    private IPortalUrlFactory urlFactory;

    public void init() throws PortletException {
        super.init();
        this.urlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    protected String getPluginName() {
        return PLUGIN_NAME;
    }

    protected void customizeCMSProperties(String customizationID, CustomizationContext context) {
        this.customizeDocumentTypes(context);
        this.customizeFragmentTypes(context);
        this.customizeTabGroups(context);
        this.customizeDomainContextualization(context);
        List menubars = this.getMenubars(context);
        menubars.add(this);
    }

    private void customizeDomainContextualization(CustomizationContext context) {
        List domainContextualizations = this.getDomainContextualizations(context);
        domainContextualizations.add(new CartounDomainContextualization());
    }

    private void customizeDocumentTypes(CustomizationContext context) {
        Map types = this.getDocTypes(context);
        DocumentType sap = new DocumentType("UsageNumServiceMetier", true, true, true, false, true, false, new ArrayList(0), "/default/templates/sap", "glyphicons glyphicons-tree-deciduous");
        types.put(sap.getName(), sap);
        DocumentType dap = new DocumentType("UsageNumDossier", true, false, false, false, false, false, new ArrayList(0), null, "glyphicons glyphicons-folder-closed");
        types.put(dap.getName(), dap);
        DocumentType activity = new DocumentType("UsageNum", false, false, false, false, false, true, new ArrayList(0), null, "glyphicons glyphicons-activity", false, false);
        types.put(activity.getName(), activity);
    }

    private void customizeFragmentTypes(CustomizationContext context) {
        Bundle bundle = this.bundleFactory.getBundle(context.getLocale());
        List types = this.getFragmentTypes(context);
        FragmentType bapeSelector = new FragmentType("bape-selector", bundle.getString("FRAGMENT_TYPE_BAPE_SELECTOR"), (IFragmentModule)new BapeSelectorFragmentModule(this.getPortletContext()));
        types.add(bapeSelector);
        FragmentType cleanSelectors = new FragmentType("clean-selectors", bundle.getString("FRAGMENT_TYPE_CLEAN_SELECTORS"), (IFragmentModule)new CleanSelectorsFragmentModule(this.getPortletContext()));
        types.add(cleanSelectors);
    }

    private void customizeTabGroups(CustomizationContext context) {
        Map tabGroups = this.getTabGroups(context);
        CartographyTabGroup cartography = new CartographyTabGroup(this.getDirectoryService());
        tabGroups.put(cartography.getName(), cartography);
    }

    public void adaptContentMenuBar(CMSServiceCtx ctx, List<MenubarItem> menuBar, CMSPublicationInfos publicationInfos, CMSExtendedDocumentInfos extendedDocumentInfos) throws CMSException {
        ListIterator<MenubarItem> menuBarIterator = menuBar.listIterator();
        while (menuBarIterator.hasNext()) {
            MenubarItem menubarItem = menuBarIterator.next();
            if (!itemsToRemove.contains(menubarItem.getId())) continue;
            menuBarIterator.remove();
        }
        Document doc = (Document)ctx.getDoc();
        if (doc != null && StringUtils.equals((String)doc.getType(), (String)"UsageNum")) {
            PortletRequest request = ctx.getRequest();
            MimeResponse response = ctx.getResponse();
            PortalControllerContext pcc = new PortalControllerContext(this.getPortletContext(), request, (PortletResponse)response);
            String canonicalURL = null;
            try {
                String webPath = NuxeoController.webIdToCmsPath((String)doc.getProperties().getString("ttc:webid"));
                canonicalURL = this.urlFactory.getPermaLink(pcc, null, null, webPath, "cms");
            }
            catch (PortalException e) {
                throw new CMSException((Throwable)e);
            }
            String title = doc.getTitle();
            String target = "_blank";
            MenubarDropdown dropdown = this.getMenubarService().getDropdown(pcc, "SHARE");
            if (dropdown != null) {
                MenubarItem item = new MenubarItem("SHARE_TWITTER", "Partager avec Twitter", "social social-twitter", (MenubarContainer)dropdown, 3, this.buildTwitterShareLink(canonicalURL, title), target, null, null);
                item.setAjaxDisabled(true);
                menuBar.add(item);
            }
        }
    }

    private String buildTwitterShareLink(String permaLinkUrl, String title) {
        StringBuilder linksb = new StringBuilder("https://twitter.com/intent/tweet?");
        linksb.append("text=");
        linksb.append(StringUtils.replace((String)title, (String)" ", (String)"+"));
        linksb.append("+");
        linksb.append("%23cartoun");
        linksb.append("+");
        linksb.append(StringUtils.replace((String)"[authentification requise]", (String)" ", (String)"+"));
        linksb.append("&url=");
        linksb.append(permaLinkUrl);
        return linksb.toString();
    }
}

