/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.cartoun.plugin.fragment;

import fr.toutatice.cartoun.plugin.util.BapeListCommand;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.PageSelectors;
import fr.toutatice.portail.cms.nuxeo.api.fragment.FragmentModule;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class BapeSelectorFragmentModule
extends FragmentModule {
    private static final String LABEL_WINDOW_PROPERTY = "bape.selector.label";
    private static final String TOOLTIP_LABEL_WINDOW_PROPERTY = "bape.selector.tooltip.label";
    private static final String SELECTOR_ID_WINDOW_PROPERTY = "bape.selector.id";
    private static final String JSP_NAME = "bape-selector";
    private static final ObjectMapper ojMapper = new ObjectMapper();
    private final DocumentDAO documentDao = DocumentDAO.getInstance();

    public BapeSelectorFragmentModule(PortletContext portletContext) {
        super(portletContext);
    }

    protected void doView(RenderRequest request, RenderResponse response, PortletContext portletContext) throws PortletException, IOException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, portletContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        String domainPath = nuxeoController.getDomainPath();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        request.setAttribute("label", (Object)window.getProperty(LABEL_WINDOW_PROPERTY));
        request.setAttribute("tooltipLabel", (Object)window.getProperty(TOOLTIP_LABEL_WINDOW_PROPERTY));
        if (StringUtils.isNotEmpty((String)domainPath)) {
            BapeListCommand command = new BapeListCommand(domainPath);
            Documents documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            if (documents.isEmpty()) {
                request.setAttribute("osivia.emptyResponse", (Object)"1");
            }
            JSONArray data = new JSONArray();
            String selectorId = window.getProperty(SELECTOR_ID_WINDOW_PROPERTY);
            Map selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
            String selectedId = null;
            for (Document doc : documents) {
                List values;
                if (selectorId != null && CollectionUtils.isNotEmpty((Collection)(values = (List)selectors.get(selectorId)))) {
                    selectedId = (String)values.get(0);
                }
                if (selectedId != null && selectedId.equals(doc.getProperties().getString("ttc:webid"))) {
                    LinkedHashMap<String, String> selectedItem = new LinkedHashMap<String, String>();
                    selectedItem.put("id", doc.getProperties().getString("ttc:webid"));
                    selectedItem.put("text", doc.getTitle());
                    request.setAttribute("selectedItem", selectedItem);
                    continue;
                }
                JSONObject selectEntry = new JSONObject();
                selectEntry.put((Object)"id", (Object)doc.getProperties().getString("ttc:webid"));
                selectEntry.put((Object)"text", (Object)doc.getTitle());
                data.add((Object)selectEntry);
            }
            request.setAttribute("data", (Object)data.toString());
        }
    }

    protected void doAdmin(RenderRequest request, RenderResponse response, PortletContext portletContext) throws PortletException, IOException {
        new NuxeoController((PortletRequest)request, (PortletResponse)response, portletContext);
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        request.setAttribute("label", (Object)window.getProperty(LABEL_WINDOW_PROPERTY));
        request.setAttribute("tooltipLabel", (Object)window.getProperty(TOOLTIP_LABEL_WINDOW_PROPERTY));
        request.setAttribute("selectorId", (Object)window.getProperty(SELECTOR_ID_WINDOW_PROPERTY));
    }

    protected void processAction(ActionRequest request, ActionResponse response, PortletContext portletContext) throws PortletException, IOException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        if (PortletMode.VIEW.equals((Object)request.getPortletMode()) && "filter".equals(request.getParameter("javax.portlet.action"))) {
            String selectorId = window.getProperty(SELECTOR_ID_WINDOW_PROPERTY);
            if (selectorId != null) {
                String selectedId = request.getParameter("selectedId");
                Map selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
                if (StringUtils.isEmpty((String)selectedId)) {
                    selectors.remove(selectorId);
                } else {
                    ArrayList<String> values = new ArrayList<String>(1);
                    values.add(request.getParameter("selectedId"));
                    selectors.put(selectorId, values);
                }
                response.setRenderParameter("selectors", PageSelectors.encodeProperties((Map)selectors));
            }
        } else if ("admin".equals(request.getPortletMode().toString()) && "save".equals(request.getParameter("javax.portlet.action"))) {
            window.setProperty(LABEL_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("label")));
            window.setProperty(TOOLTIP_LABEL_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("tooltipLabel")));
            window.setProperty(SELECTOR_ID_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("selectorId")));
        }
    }

    public boolean isDisplayedInAdmin() {
        return true;
    }

    public String getViewJSPName() {
        return JSP_NAME;
    }

    public String getAdminJSPName() {
        return JSP_NAME;
    }
}

