<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://www.osivia.org/jsp/taglib/osivia-portal" prefix="op" %>

<%@ page isELIgnored="false"%>


<portlet:defineObjects />

<portlet:actionURL name="filter" var="url" />
<c:set var="clearLabel"><op:translate key="CLEAR"/></c:set>
<c:set var="namespace"><portlet:namespace /></c:set>

<script type="text/javascript">
$JQry(function() {
	$JQry("#${namespace}-selector").select2({
		data: ${data},
		theme: "bootstrap",
		width: "resolve"
	})
});
</script>

<c:if test="${not empty data}">
	<form action="${url}" method="post" role="form">
	    <div class="form-group">
	        <c:if test="${not empty label}">
	            <label for="${namespace}-selector" class="control-label" data-placement="right" data-toggle="tooltip" data-original-title="${tooltipLabel}">${label}</label>
	        </c:if>
	        
	        <div class="input-group select2-bootstrap-append">
		        <select id="${namespace}-selector" name="selectedId" class="form-control select2" onchange="$JQry('#${namespace}-submit').click()">
		        	<option value=""><op:translate key="ALL" /></option>
		            <c:if test="${not empty selectedItem}">
		            	<option value="${selectedItem.id}" selected="selected">${selectedItem.text}</option>
		            </c:if>
		        </select>
		        
		        <!-- Clear -->
	            <span class="input-group-btn">
	                <button type="submit" name="clear" class="btn btn-default" title="${clearLabel}" data-toggle="tooltip" data-placement="bottom">
	                    <i class="glyphicons glyphicons-delete"></i>
	                    <span class="sr-only">${clearLabel}</span>
	                </button>
	            </span>
            </div>
	    </div>
	    
	    <div class="form-group hidden-script">
	        <button id="${namespace}-submit" type="submit" class="btn btn-default">
	            <span><op:translate key="SAVE" /></span>
	        </button>
	    </div>
	</form>
</c:if>
